package com.elitesland.cbpl.infinity.server.platform.vo.param;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 接口平台(对接系统)
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("接口平台(对接系统)")
public class PlatformSaveParamVO {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台名称")
    @NotBlank(message = "平台名称必填")
    private String platformName;

    @ApiModelProperty(value = "平台编码")
    @NotBlank(message = "平台编码必填")
    private String platformCode;

    @ApiModelProperty(value = "服务url前缀")
    @NotBlank(message = "URL必填")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    @NotBlank(message = "认证方式必填")
    private String authMethod;

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;

    public boolean isNew() {
        return ObjectUtil.isNull(id);
    }
}
