package com.elitesland.cbpl.infinity.web.security.service.oauth2;

import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

import java.nio.charset.StandardCharsets;

/**
 * @author eric.hao
 * @since 2024/06/07
 */
@Slf4j
@RequiredArgsConstructor
public class OAuth2Client {

    private final WebClient webClient;

    public String getAccessToken(String url, String clientId, String clientSecret) {
        AccessToken token = authentication(url, clientId, clientSecret, AccessToken.class);
        String accessToken = token.getAccessToken();
        LogUtil.info("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken);
        return accessToken;
    }

    public String authentication(String url, String clientId, String clientSecret) {
        String accessToken = authentication(url, clientId, clientSecret, String.class);
        LogUtil.info("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken);
        return accessToken;
    }

    public <T> T authentication(String url, String clientId, String clientSecret, Class<T> clazz) {
        LogUtil.info("[BPMN][INFINITY] OAuth2 Url: " + url);
        LogUtil.info("[BPMN][INFINITY] OAuth2 clientId: " + clientId);
        var uriSpec = webClient.method(HttpMethod.POST);
        var bodySpec = uriSpec.uri(url);
        bodySpec.acceptCharset(StandardCharsets.UTF_8);
        bodySpec.contentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, Object> multiValueMap = new LinkedMultiValueMap<>();
        multiValueMap.add("grant_type", "client_credentials");
        multiValueMap.add("client_id", clientId);
        multiValueMap.add("client_secret", clientSecret);
        bodySpec.body(BodyInserters.fromMultipartData(multiValueMap));
        return bodySpec.retrieve().bodyToMono(clazz).block();
    }
}
