/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.api.vo.resp;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.infinity.web.security.util.AuthAccountResolve;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import lombok.NonNull;
import org.springframework.http.HttpMethod;

@ApiModel(value="\u63a5\u53e3\u5b9a\u4e49")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InfinityApiRespVO
implements Comparable<InfinityApiRespVO> {
    @ApiModelProperty(value="\u552f\u4e00\u6807\u8bc6")
    private Long id;
    @ApiModelProperty(value="\u5e73\u53f0\u7f16\u7801")
    private String platformCode;
    @ApiModelProperty(value="\u5206\u7ec4id")
    private Long folderId;
    @ApiModelProperty(value="\u76ee\u5f55\u540d\u79f0")
    private String folderName;
    @ApiModelProperty(value="\u670d\u52a1url\u524d\u7f00")
    private String serverUrl;
    @ApiModelProperty(value="\u8ba4\u8bc1\u65b9\u5f0f")
    private String authMethod;
    @ApiModelProperty(value="\u8ba4\u8bc1\u65b9\u5f0f\u4e2d\u6587")
    private String authMethodName;
    @JsonIgnore
    @ApiModelProperty(value="\u8ba4\u8bc1\u8d26\u53f7")
    private String authAccount;
    @ApiModelProperty(value="BasicAuth \u8ba4\u8bc1\u8d26\u53f7")
    private BasicAuthAccountVO basicAuthAccount;
    @ApiModelProperty(value="OAuth2.0 \u8ba4\u8bc1\u8d26\u53f7")
    private OAuth2AccountVO oauth2Account;
    @ApiModelProperty(value="\u63a5\u53e3\u7f16\u7801")
    private String apiCode;
    @ApiModelProperty(value="\u63a5\u53e3\u540d\u79f0")
    private String apiName;
    @ApiModelProperty(value="\u63a5\u53e3\u5730\u5740")
    private String apiUrl;
    @ApiModelProperty(value="\u8bf7\u6c42\u65b9\u5f0f")
    @Enumerated(value=EnumType.STRING)
    private HttpMethod requestMethod;
    @ApiModelProperty(value="\u63a5\u53e3\u72b6\u6001")
    private Integer apiStatus;
    @ApiModelProperty(value="\u63a5\u53e3\u72b6\u6001\u4e2d\u6587")
    private String apiStatusName;
    @ApiModelProperty(value="\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(value="\u8bb0\u5f55\u521b\u5efa\u8005id")
    private Long createUserId;
    @ApiModelProperty(value="\u8bb0\u5f55\u521b\u5efa\u8005")
    private String creator;
    @ApiModelProperty(value="\u8bb0\u5f55\u521b\u5efa\u65f6\u95f4")
    private LocalDateTime createTime;
    @ApiModelProperty(value="\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u8005id")
    private Long modifyUserId;
    @ApiModelProperty(value="\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u8005")
    private String updater;
    @ApiModelProperty(value="\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u65f6\u95f4")
    private LocalDateTime modifyTime;
    @ApiModelProperty(value="\u5b50\u8282\u70b9")
    private List<InfinityApiRespVO> children;

    public String getAuthMethodName() {
        return AuthMethod.fromCode((String)this.authMethod);
    }

    public BasicAuthAccountVO getBasicAuthAccount() {
        return AuthAccountResolve.getBasicAuthAccount(this.authMethod, this.authAccount);
    }

    public OAuth2AccountVO getOauth2Account() {
        return AuthAccountResolve.getOauth2Account(this.authMethod, this.authAccount);
    }

    public String getApiStatusName() {
        return ActiveStatus.fromCode((Integer)this.apiStatus);
    }

    public InfinityApiRespVO folderNode() {
        InfinityApiRespVO result = new InfinityApiRespVO();
        result.setFolderId(this.getFolderId());
        result.setFolderName(this.getFolderName());
        result.setServerUrl(this.getServerUrl());
        result.setAuthMethod(this.getAuthMethod());
        result.setAuthMethodName(this.getAuthMethodName());
        return result;
    }

    @Override
    public int compareTo(@NonNull InfinityApiRespVO prev) {
        if (prev == null) {
            throw new NullPointerException("prev is marked non-null but is null");
        }
        if (prev.getFolderId() != null && this.getFolderId() == null) {
            return 1;
        }
        if (prev.getFolderId() == null && this.getFolderId() != null) {
            return -1;
        }
        if (prev.getFolderId() != null && this.getFolderId() != null) {
            int folderSort = this.getFolderName().compareTo(prev.getFolderName());
            if (folderSort == 0) {
                return this.getApiName().compareTo(prev.getApiName());
            }
            return folderSort;
        }
        return this.getApiName().compareTo(prev.getApiName());
    }

    public Long getId() {
        return this.id;
    }

    public String getPlatformCode() {
        return this.platformCode;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getAuthAccount() {
        return this.authAccount;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public Integer getApiStatus() {
        return this.apiStatus;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getCreateUserId() {
        return this.createUserId;
    }

    public String getCreator() {
        return this.creator;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public Long getModifyUserId() {
        return this.modifyUserId;
    }

    public String getUpdater() {
        return this.updater;
    }

    public LocalDateTime getModifyTime() {
        return this.modifyTime;
    }

    public List<InfinityApiRespVO> getChildren() {
        return this.children;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setAuthMethodName(String authMethodName) {
        this.authMethodName = authMethodName;
    }

    @JsonIgnore
    public void setAuthAccount(String authAccount) {
        this.authAccount = authAccount;
    }

    public void setBasicAuthAccount(BasicAuthAccountVO basicAuthAccount) {
        this.basicAuthAccount = basicAuthAccount;
    }

    public void setOauth2Account(OAuth2AccountVO oauth2Account) {
        this.oauth2Account = oauth2Account;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setRequestMethod(HttpMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setApiStatus(Integer apiStatus) {
        this.apiStatus = apiStatus;
    }

    public void setApiStatusName(String apiStatusName) {
        this.apiStatusName = apiStatusName;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setModifyUserId(Long modifyUserId) {
        this.modifyUserId = modifyUserId;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public void setModifyTime(LocalDateTime modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setChildren(List<InfinityApiRespVO> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfinityApiRespVO)) {
            return false;
        }
        InfinityApiRespVO other = (InfinityApiRespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$folderId = this.getFolderId();
        Long other$folderId = other.getFolderId();
        if (this$folderId == null ? other$folderId != null : !((Object)this$folderId).equals(other$folderId)) {
            return false;
        }
        Integer this$apiStatus = this.getApiStatus();
        Integer other$apiStatus = other.getApiStatus();
        if (this$apiStatus == null ? other$apiStatus != null : !((Object)this$apiStatus).equals(other$apiStatus)) {
            return false;
        }
        Long this$createUserId = this.getCreateUserId();
        Long other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !((Object)this$createUserId).equals(other$createUserId)) {
            return false;
        }
        Long this$modifyUserId = this.getModifyUserId();
        Long other$modifyUserId = other.getModifyUserId();
        if (this$modifyUserId == null ? other$modifyUserId != null : !((Object)this$modifyUserId).equals(other$modifyUserId)) {
            return false;
        }
        String this$platformCode = this.getPlatformCode();
        String other$platformCode = other.getPlatformCode();
        if (this$platformCode == null ? other$platformCode != null : !this$platformCode.equals(other$platformCode)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$authMethod = this.getAuthMethod();
        String other$authMethod = other.getAuthMethod();
        if (this$authMethod == null ? other$authMethod != null : !this$authMethod.equals(other$authMethod)) {
            return false;
        }
        String this$authMethodName = this.getAuthMethodName();
        String other$authMethodName = other.getAuthMethodName();
        if (this$authMethodName == null ? other$authMethodName != null : !this$authMethodName.equals(other$authMethodName)) {
            return false;
        }
        String this$authAccount = this.getAuthAccount();
        String other$authAccount = other.getAuthAccount();
        if (this$authAccount == null ? other$authAccount != null : !this$authAccount.equals(other$authAccount)) {
            return false;
        }
        BasicAuthAccountVO this$basicAuthAccount = this.getBasicAuthAccount();
        BasicAuthAccountVO other$basicAuthAccount = other.getBasicAuthAccount();
        if (this$basicAuthAccount == null ? other$basicAuthAccount != null : !((Object)this$basicAuthAccount).equals(other$basicAuthAccount)) {
            return false;
        }
        OAuth2AccountVO this$oauth2Account = this.getOauth2Account();
        OAuth2AccountVO other$oauth2Account = other.getOauth2Account();
        if (this$oauth2Account == null ? other$oauth2Account != null : !((Object)this$oauth2Account).equals(other$oauth2Account)) {
            return false;
        }
        String this$apiCode = this.getApiCode();
        String other$apiCode = other.getApiCode();
        if (this$apiCode == null ? other$apiCode != null : !this$apiCode.equals(other$apiCode)) {
            return false;
        }
        String this$apiName = this.getApiName();
        String other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
            return false;
        }
        String this$apiUrl = this.getApiUrl();
        String other$apiUrl = other.getApiUrl();
        if (this$apiUrl == null ? other$apiUrl != null : !this$apiUrl.equals(other$apiUrl)) {
            return false;
        }
        HttpMethod this$requestMethod = this.getRequestMethod();
        HttpMethod other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        String this$apiStatusName = this.getApiStatusName();
        String other$apiStatusName = other.getApiStatusName();
        if (this$apiStatusName == null ? other$apiStatusName != null : !this$apiStatusName.equals(other$apiStatusName)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updater = this.getUpdater();
        String other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        LocalDateTime this$modifyTime = this.getModifyTime();
        LocalDateTime other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        List<InfinityApiRespVO> this$children = this.getChildren();
        List<InfinityApiRespVO> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfinityApiRespVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $folderId = this.getFolderId();
        result = result * 59 + ($folderId == null ? 43 : ((Object)$folderId).hashCode());
        Integer $apiStatus = this.getApiStatus();
        result = result * 59 + ($apiStatus == null ? 43 : ((Object)$apiStatus).hashCode());
        Long $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : ((Object)$createUserId).hashCode());
        Long $modifyUserId = this.getModifyUserId();
        result = result * 59 + ($modifyUserId == null ? 43 : ((Object)$modifyUserId).hashCode());
        String $platformCode = this.getPlatformCode();
        result = result * 59 + ($platformCode == null ? 43 : $platformCode.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $authMethod = this.getAuthMethod();
        result = result * 59 + ($authMethod == null ? 43 : $authMethod.hashCode());
        String $authMethodName = this.getAuthMethodName();
        result = result * 59 + ($authMethodName == null ? 43 : $authMethodName.hashCode());
        String $authAccount = this.getAuthAccount();
        result = result * 59 + ($authAccount == null ? 43 : $authAccount.hashCode());
        BasicAuthAccountVO $basicAuthAccount = this.getBasicAuthAccount();
        result = result * 59 + ($basicAuthAccount == null ? 43 : ((Object)$basicAuthAccount).hashCode());
        OAuth2AccountVO $oauth2Account = this.getOauth2Account();
        result = result * 59 + ($oauth2Account == null ? 43 : ((Object)$oauth2Account).hashCode());
        String $apiCode = this.getApiCode();
        result = result * 59 + ($apiCode == null ? 43 : $apiCode.hashCode());
        String $apiName = this.getApiName();
        result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
        String $apiUrl = this.getApiUrl();
        result = result * 59 + ($apiUrl == null ? 43 : $apiUrl.hashCode());
        HttpMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        String $apiStatusName = this.getApiStatusName();
        result = result * 59 + ($apiStatusName == null ? 43 : $apiStatusName.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        LocalDateTime $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        List<InfinityApiRespVO> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "InfinityApiRespVO(id=" + this.getId() + ", platformCode=" + this.getPlatformCode() + ", folderId=" + this.getFolderId() + ", folderName=" + this.getFolderName() + ", serverUrl=" + this.getServerUrl() + ", authMethod=" + this.getAuthMethod() + ", authMethodName=" + this.getAuthMethodName() + ", authAccount=" + this.getAuthAccount() + ", basicAuthAccount=" + this.getBasicAuthAccount() + ", oauth2Account=" + this.getOauth2Account() + ", apiCode=" + this.getApiCode() + ", apiName=" + this.getApiName() + ", apiUrl=" + this.getApiUrl() + ", requestMethod=" + this.getRequestMethod() + ", apiStatus=" + this.getApiStatus() + ", apiStatusName=" + this.getApiStatusName() + ", remark=" + this.getRemark() + ", createUserId=" + this.getCreateUserId() + ", creator=" + this.getCreator() + ", createTime=" + this.getCreateTime() + ", modifyUserId=" + this.getModifyUserId() + ", updater=" + this.getUpdater() + ", modifyTime=" + this.getModifyTime() + ", children=" + this.getChildren() + ")";
    }
}

