package com.elitesland.cbpl.infinity.bpmn.component;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 接口调度节点
 *
 * @author eric.hao
 * @since 2024/05/21
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_INFINITY)
public class InfinityStandardComponent extends NodeComponent {

    /**
     * 接口编码
     */
    private static final String INFINITY_API_CODE = "IAC";

    @Resource
    private InfinityRestClient restClient;

    @SuppressWarnings("unchecked")
    @Override
    public void process() throws Exception {
        // 节点流程入参
        var nodeParam = this.getCmpData(Map.class);
        // 上下文参数
        var standardContext = this.getContextBean(StandardContext.class);
        // 接口参数
        HttpParam httpParam = BeanUtils.toBean(standardContext.getPrevParam(), HttpParam.class);
        // 1. 指定接口编码
        String apiCode = nodeParam.getOrDefault(INFINITY_API_CODE, "").toString();
        if (StrUtil.isBlank(apiCode)) {
            LogUtil.error("[BPMN][INFINITY] 未传接口编码，执行失败.");
            return;
        }
        LogUtil.info("[BPMN][INFINITY] 接口编码: " + apiCode);
        // 2. 接口调用
        InfinityResult<Object> resp = ObjectUtil.isNull(httpParam) ? restClient.exchange(apiCode, Object.class) :
                restClient.exchange(apiCode, Object.class, (builder) -> {
                    if (StrUtil.isNotBlank(httpParam.getBizKey())) {
                        builder.bizKey(httpParam.getBizKey());
                    }
                    if (MapUtil.isNotEmpty(httpParam.getHeaderParam())) {
                        builder.headerParam(httpParam.getHeaderParam());
                    }
                    if (MapUtil.isNotEmpty(httpParam.getQueryParam())) {
                        builder.queryParam(httpParam.getQueryParam());
                    }
                    if (MapUtil.isNotEmpty(httpParam.getPathParam())) {
                        builder.pathParam(httpParam.getPathParam());
                    }
                    if (ObjectUtil.isNotNull(httpParam.getBodyParam())) {
                        builder.bodyParam(httpParam.getBodyParam());
                    }
                    return builder.build();
                });
        // 3. 将结果作为出参
        Object response = resp.toEntity();
        standardContext.setResponse(response);
        LogUtil.info("[BPMN][INFINITY] 接口结果: ", response);
    }
}
