package com.elitesland.cbpl.infinity.bpmn.component;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.data.etl.util.DataETL;
import com.elitesland.cbpl.infinity.common.constant.DataType;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 数据结构转换节点
 *
 * @author eric.hao
 * @since 2024/05/21
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_TRANSFORM)
public class InfinityTransformComponent extends NodeComponent {

    /**
     * 模版编码
     */
    private static final String TRANSFORM_TEMPLATE_CODE = "TTC";

    /**
     * 返回数据结构：object、array
     */
    private static final String TRANSFORM_RESPONSE_TYPE = "TRT";

    @SuppressWarnings("unchecked")
    @Override
    public void process() throws Exception {
        // 节点流程入参
        var nodeParam = this.getCmpData(Map.class);
        // 上下文参数
        var ctx = this.getContextBean(StandardContext.class);

        // 1. 指定Transform模板编码
        String templateCode = nodeParam.getOrDefault(TRANSFORM_TEMPLATE_CODE, "").toString();
        if (StrUtil.isBlank(templateCode)) {
            LogUtil.error("[BPMN][ETL] 模版编码为空.");
            return;
        }
        LogUtil.info("[BPMN][ETL] 模板编码: " + templateCode);
        // 2. 数据结构转换
        Object prevParam = ctx.getPrevParam();
        LogUtil.info("[BPMN][ETL] 转换前报文: ", prevParam);
        String result = DataETL.transform(templateCode, prevParam);
        LogUtil.info("[BPMN][ETL] 转换成JSON格式字符串: ", result);
        // 3.1 如果未指定类型，直接返回
        Object responseType = String.valueOf(nodeParam.get(TRANSFORM_RESPONSE_TYPE));
        LogUtil.info("[BPMN][ETL] 转换结果的类型(object/array): " + responseType);
        if (responseType.equals("null")) {
            ctx.setResponse(result);
        }
        // 3.2 返回对象
        else if (responseType.equals(DataType.Object.getCode())) {
            ctx.setResponse(BeanUtils.toMap(result));
        }
        // 3.3 返回数组
        else if (responseType.equals(DataType.Array.getCode())) {
            ctx.setResponse(BeanUtils.toMapList(result));
        }
    }
}
