package com.elitesland.cbpl.infinity.common.controller;

import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/05/27
 */
@Slf4j
@Api(tags = "通用接口")
@RestController
@RequestMapping("/infinity/common")
@AllArgsConstructor
public class InfinityCommonApi {

    @ApiOperation(value = "日志删除策略")
    @GetMapping(value = "/auth_method")
    public HttpResult<List<EnumValues>> authMethod() {
        List<EnumValues> result = Arrays.stream(AuthMethod.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
        return HttpResult.ok(result);
    }
}
