package com.elitesland.cbpl.infinity.server.account.convert;

import com.elitesland.cbpl.infinity.server.account.entity.InfinityAccountDO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountSaveParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountDetailVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinityAccountConvert {

	InfinityAccountConvert INSTANCE = Mappers.getMapper(InfinityAccountConvert.class);

    /**
     * DO => RespVO
     */
    InfinityAccountDetailVO doToVO(InfinityAccountDO infinityAccountDO);

    /**
     * SaveParam => DO
     */
    InfinityAccountDO saveParamToDO(InfinityAccountSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(InfinityAccountSaveParamVO saveParam, @MappingTarget InfinityAccountDO infinityAccountDO);
}
