package com.elitesland.cbpl.infinity.web.security.domain;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/06/07
 */
@Data
public class BasicAuthAccountVO {

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    @JsonIgnore
    public boolean isEmpty() {
        return StrUtil.isBlank(username) || StrUtil.isBlank(password);
    }
}
