package com.elitesland.cbpl.infinity.server.api.domain;

import com.elitesland.cbpl.infinity.common.constant.DataType;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/05/17
 */
@Data
@ApiModel("JSON参数")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class JsonColumnDefinition {

    /**
     * 取值参考：{@link DataType}
     */
    @ApiModelProperty("字段类型")
    private String type;

    @ApiModelProperty("中文名")
    private String title;

    @ApiModelProperty("说明")
    private String description;

    @ApiModelProperty("子节点：字段类型为`array`时有值")
    private List<JsonColumnDefinition> items;

    @ApiModelProperty("子节点：字段类型为`object`时有值")
    private Map<String, JsonColumnDefinition> properties;
}
