/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.api.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.server.api.convert.InfinityApiConvert;
import com.elitesland.cbpl.infinity.server.api.entity.InfinityApiDO;
import com.elitesland.cbpl.infinity.server.api.repo.InfinityApiRepo;
import com.elitesland.cbpl.infinity.server.api.repo.InfinityApiRepoProc;
import com.elitesland.cbpl.infinity.server.api.service.InfinityApiService;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiQueryParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiSaveParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiDetailVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiMergeVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;
import com.elitesland.cbpl.infinity.server.folder.convert.InfinityFolderConvert;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.repo.InfinityFolderRepoProc;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfinityApiServiceImpl
implements InfinityApiService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityApiServiceImpl.class);
    private final InfinityApiRepo infinityApiRepo;
    private final InfinityApiRepoProc infinityApiRepoProc;
    private final InfinityFolderRepoProc folderRepoProc;

    @Override
    public List<InfinityApiRespVO> infinityApiByParam(ApiQueryParamVO query) {
        List<InfinityApiRespVO> responseVO = this.infinityApiRepoProc.infinityApiByParam(query);
        Map<Long, InfinityApiRespVO> folderMap = this.queryFolderByParam(query);
        Map<Long, List<InfinityApiRespVO>> apiMap = responseVO.stream().filter(row -> row.getFolderId() != null).collect(Collectors.groupingBy(InfinityApiRespVO::getFolderId));
        responseVO.removeIf(row -> row.getFolderId() != null);
        apiMap.forEach((folderId, children) -> {
            InfinityApiRespVO curr = (InfinityApiRespVO)BeanUtils.toBean(folderMap.get(folderId), InfinityApiRespVO.class);
            children.sort(InfinityApiRespVO::compareTo);
            curr.setChildren((List<InfinityApiRespVO>)children);
            responseVO.add(curr);
            folderMap.remove(folderId);
        });
        folderMap.forEach((folderId, api) -> responseVO.add((InfinityApiRespVO)api));
        responseVO.sort(InfinityApiRespVO::compareTo);
        return responseVO;
    }

    private Map<Long, InfinityApiRespVO> queryFolderByParam(ApiQueryParamVO query) {
        List<InfinityFolderDO> folderRespVOS = this.folderRepoProc.infinityFolderByParam(query);
        List<InfinityApiRespVO> folders = InfinityFolderConvert.INSTANCE.toApiFolder(folderRespVOS);
        return folders.stream().collect(Collectors.toMap(InfinityApiRespVO::getFolderId, Function.identity()));
    }

    @Override
    public InfinityApiDetailVO infinityApiById(Long id) {
        Optional infinityApiDO = this.infinityApiRepo.findById(id);
        if (infinityApiDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return InfinityApiConvert.INSTANCE.doToVO((InfinityApiDO)infinityApiDO.get());
    }

    @Override
    public InfinityApiDetailVO infinityApiByApiCode(String apiCode) {
        InfinityApiMergeVO apiMergeVO = this.infinityApiRepoProc.findByApiCode(apiCode);
        if (ObjectUtil.isNull((Object)apiMergeVO)) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return InfinityApiConvert.INSTANCE.mergeToDetailVO(apiMergeVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApiSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            InfinityApiDO infinityApiDO = InfinityApiConvert.INSTANCE.saveParamToDO(saveParam);
            this.infinityApiRepo.save(infinityApiDO);
            return infinityApiDO.getId();
        }
        Optional infinityApiDO = this.infinityApiRepo.findById(saveParam.getId());
        if (infinityApiDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinityApiDO infinityApi = (InfinityApiDO)infinityApiDO.get();
        InfinityApiConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityApi);
        this.infinityApiRepo.save(infinityApi);
        return infinityApi.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, int status) {
        this.infinityApiRepoProc.updateStatus(id, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.infinityApiRepoProc.delete(ids);
    }

    public InfinityApiServiceImpl(InfinityApiRepo infinityApiRepo, InfinityApiRepoProc infinityApiRepoProc, InfinityFolderRepoProc folderRepoProc) {
        this.infinityApiRepo = infinityApiRepo;
        this.infinityApiRepoProc = infinityApiRepoProc;
        this.folderRepoProc = folderRepoProc;
    }
}

