/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.platform.service.impl;

import com.elitesland.cbpl.infinity.server.platform.convert.InfinityPlatformConvert;
import com.elitesland.cbpl.infinity.server.platform.entity.InfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepo;
import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepoProc;
import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformPagingParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformSaveParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformPagingVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfinityPlatformServiceImpl
implements InfinityPlatformService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityPlatformServiceImpl.class);
    private final InfinityPlatformRepo platformRepo;
    private final InfinityPlatformRepoProc platformRepoProc;

    @Override
    public PagingVO<PlatformPagingVO> platformPageBy(PlatformPagingParamVO query) {
        long count = this.platformRepoProc.platformCountBy(query);
        if (count > 0L) {
            List<InfinityPlatformDO> list = this.platformRepoProc.platformPageBy(query);
            return new PagingVO(count, InfinityPlatformConvert.INSTANCE.toPageVO(list));
        }
        return new PagingVO();
    }

    @Override
    public List<PlatformRespVO> platformByParam(PlatformQueryParamVO query) {
        List<InfinityPlatformDO> list = this.platformRepoProc.platformByParam(query);
        return InfinityPlatformConvert.INSTANCE.doToVO(list);
    }

    @Override
    public PlatformRespVO platformById(Long id) {
        Optional infinityPlatformDO = this.platformRepo.findById(id);
        if (infinityPlatformDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return InfinityPlatformConvert.INSTANCE.doToVO((InfinityPlatformDO)infinityPlatformDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(PlatformSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            InfinityPlatformDO infinityPlatformDO = InfinityPlatformConvert.INSTANCE.saveParamToDO(saveParam);
            this.platformRepo.save(infinityPlatformDO);
            return infinityPlatformDO.getId();
        }
        Optional infinityPlatformDO = this.platformRepo.findById(saveParam.getId());
        if (infinityPlatformDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinityPlatformDO infinityPlatform = (InfinityPlatformDO)infinityPlatformDO.get();
        InfinityPlatformConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityPlatform);
        this.platformRepo.save(infinityPlatform);
        return infinityPlatform.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.platformRepoProc.delete(ids);
    }

    public InfinityPlatformServiceImpl(InfinityPlatformRepo platformRepo, InfinityPlatformRepoProc platformRepoProc) {
        this.platformRepo = platformRepo;
        this.platformRepoProc = platformRepoProc;
    }
}

