/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.oauth2;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.security.service.oauth2.AccessToken;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import com.elitesland.cbpl.tool.redis.util.RedisUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Client {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Client.class);
    private final RestWrapper restWrapper;
    private final RedisUtil redisUtil;

    public String getAccessToken(String platformCode, String url, String clientId, String clientSecret) {
        String tokenKey = this.tokenKey(platformCode, clientId);
        String cacheToken = this.redisUtil.getString(tokenKey);
        if (StrUtil.isNotBlank((CharSequence)cacheToken)) {
            LogUtil.info((String)("[BPMN][INFINITY] CacheToken(" + tokenKey + "): "), (Object)cacheToken);
            return cacheToken;
        }
        return this.createAccessToken(platformCode, url, clientId, clientSecret);
    }

    private String createAccessToken(String platformCode, String url, String clientId, String clientSecret) {
        AccessToken token = this.authentication(url, clientId, clientSecret, AccessToken.class);
        String accessToken = token.getAccessToken();
        Long expiresIn = token.getExpiresIn();
        LogUtil.info((String)"[BPMN][INFINITY] AccessToken: ", (Object)accessToken);
        LogUtil.info((String)"[BPMN][INFINITY] ExpiresIn: ", (Object)expiresIn);
        if (expiresIn > 10L) {
            this.redisUtil.set(this.tokenKey(platformCode, clientId), (Object)accessToken, expiresIn - 5L, TimeUnit.SECONDS);
        }
        return accessToken;
    }

    public String authentication(String url, String clientId, String clientSecret) {
        String accessToken = this.authentication(url, clientId, clientSecret, String.class);
        LogUtil.info((String)"[BPMN][INFINITY] AccessToken: ", (Object)accessToken);
        return accessToken;
    }

    public <T> T authentication(String url, String clientId, String clientSecret, Class<T> clazz) {
        LogUtil.info((String)"[BPMN][INFINITY] Url: ", (Object)url);
        LogUtil.info((String)"[BPMN][INFINITY] ClientId: ", (Object)clientId);
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("grant_type", "client_credentials");
            param.put("client_id", clientId);
            param.put("client_secret", clientSecret);
            String result = this.restWrapper.postFormUrlencoded(url, param);
            return (T)BeanUtils.toBean((String)result, clazz);
        }
        catch (Exception e) {
            LogUtil.error((String)"[BPMN][INFINITY] \u8ba4\u8bc1\u5931\u8d25\uff1a", (String)ExceptionUtils.formatException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private String tokenKey(String platformCode, String clientId) {
        ArrayList values = ListUtil.toList((Object[])new String[]{platformCode, clientId});
        String tenantCode = TenantSpiUtil.currentTenantCode();
        if (StrUtil.isNotBlank((CharSequence)tenantCode)) {
            values.add(tenantCode);
        }
        return StrUtil.join((CharSequence)"_", (Iterable)values);
    }

    public OAuth2Client(RestWrapper restWrapper, RedisUtil redisUtil) {
        this.restWrapper = restWrapper;
        this.redisUtil = redisUtil;
    }
}

