/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.oauth2;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.config.InfinityWebProperties;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.infinity.web.security.service.oauth2.OAuth2Client;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@UnicomTag(value="OAUTH_2.0")
public class OAuth2SecurityService
implements SecurityAuthService {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2SecurityService.class);
    @Autowired(required=false)
    private OAuth2Client authClient;

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info((String)("[BPMN][INFINITY] \u8ba4\u8bc1\u65b9\u5f0f: " + AuthMethod.AUTH_METHOD_OAUTH_V2.getDesc()));
        if (!InfinityWebProperties.INFINITY_WEB_ENABLED) {
            LogUtil.error((String)"[BPMN][INFINITY] WebClient not enabled.");
            throw new RuntimeException("WebClient not enabled.");
        }
        OAuth2AccountVO account = param.getApiConfig().getOauth2Account();
        if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
            LogUtil.error((String)"[BPMN][INFINITY] \u672a\u7ef4\u62a4\u8ba4\u8bc1\u8d26\u53f7.");
            throw new RuntimeException("account is empty.");
        }
        String accessToken = this.authClient.getAccessToken(param.getPlatformCode(), account.getUrl(), account.getClientId(), account.getClientSecret());
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            LogUtil.error((String)"[BPMN][INFINITY] token\u4e3a\u7a7a.");
            return false;
        }
        uri.header("Authorization", new String[]{"Bearer " + accessToken});
        return true;
    }
}

