package com.elitesland.cbpl.infinity.web.http.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.infinity.web.http.vo.InvokeParam;
import com.elitesland.cbpl.tool.core.map.MapUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2024/05/20
 */
@Slf4j
@Api(tags = "接口调用")
@RestController
@RequestMapping("/infinity/web")
@RequiredArgsConstructor
public class InfinityWebController {

    private final InfinityRestClient restClient;

    @ApiOperation(value = "执行一次")
    @PostMapping("/invoke/{apiCode}")
    public Object invoke(@PathVariable("apiCode") String apiCode, @RequestBody InvokeParam payload) {
        InfinityResult<Object> resp = restClient.exchange(apiCode, Object.class, (builder) -> {
            if (StrUtil.isNotBlank(payload.getBizKey())) {
                builder.bizKey(payload.getBizKey());
            }
            if (MapUtil.isNotEmpty(payload.getHeaderParam())) {
                builder.headerParam(MapUtils.convert(payload.getHeaderParam()));
            }
            if (MapUtil.isNotEmpty(payload.getQueryParam())) {
                builder.queryParam(MapUtils.convert(payload.getQueryParam()));
            }
            if (MapUtil.isNotEmpty(payload.getPathParam())) {
                builder.pathParam(payload.getPathParam());
            }
            if (ObjectUtil.isNotNull(payload.getBodyParam())) {
                builder.bodyParam(payload.getBodyParam());
            }
            return builder.build();
        });
        return resp.toEntity();
    }
}
