/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.common.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.common.service.AuthMethodService;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class DefaultAuthMethodService
implements AuthMethodService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthMethodService.class);

    @Override
    public List<EnumValues> authMethod() {
        return Arrays.stream(AuthMethod.values()).map(name -> EnumValues.of((String)name.getCode(), (String)name.getDesc())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> fromCode(List<String> authMethodCodes) {
        HashMap<String, String> authMethodNames = new HashMap<String, String>();
        if (CollUtil.isEmpty(authMethodCodes)) {
            return authMethodNames;
        }
        for (String authMethodCode : authMethodCodes) {
            authMethodNames.put(authMethodCode, AuthMethod.fromCode((String)authMethodCode));
        }
        return authMethodNames;
    }
}

