/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.param;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.common.constant.MediaType;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiDetailVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;

@ApiModel(value="\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570")
public class HttpParam {
    @ApiModelProperty(value="\u4e1a\u52a1\u4e3b\u952e")
    private String bizKey;
    @ApiModelProperty(value="\u63a5\u53e3\u5730\u5740")
    private String url;
    @ApiModelProperty(value="\u8ba4\u8bc1\u65b9\u5f0f")
    private String authMethod;
    @ApiModelProperty(value="\u8bf7\u6c42\u65b9\u5f0f")
    @Enumerated(value=EnumType.STRING)
    private HttpMethod requestMethod;
    @ApiModelProperty(value="\u8bf7\u6c42\u5934\u7684\u5a92\u4f53\u7c7b\u578b")
    private String mediaType;
    @ApiModelProperty(value="\u63a5\u53e3\u914d\u7f6e")
    private InfinityApiDetailVO apiConfig;
    @ApiModelProperty(value="header\u53c2\u6570")
    private MultiValueMap<String, String> headerParam;
    @ApiModelProperty(value="\u67e5\u8be2\u53c2\u6570")
    private MultiValueMap<String, String> queryParam;
    @ApiModelProperty(value="\u8def\u5f84\u53c2\u6570")
    private Map<String, String> pathParam;
    @ApiModelProperty(value="body\u53c2\u6570")
    private Object bodyParam;

    @JsonIgnore
    @ApiModelProperty(value="\u5e73\u53f0\u7f16\u7801")
    public String getPlatformCode() {
        return this.apiConfig.getPlatformCode();
    }

    @JsonIgnore
    @ApiModelProperty(value="\u63a5\u53e3\u7f16\u7801")
    public String getApiCode() {
        return this.apiConfig.getApiCode();
    }

    public String getUrl() {
        return this.apiConfig.getServerUrl() + this.apiConfig.getApiUrl();
    }

    public String getAuthMethod() {
        return this.apiConfig.getAuthMethod();
    }

    public HttpMethod getRequestMethod() {
        return this.apiConfig.getRequestMethod();
    }

    public String getMediaType() {
        return this.apiConfig.getMediaType();
    }

    @JsonIgnore
    public boolean needBodyParam() {
        return !this.getMediaType().equals(MediaType.MIME_NONE.getCode()) && ObjectUtil.isNotNull((Object)this.getBodyParam());
    }

    @JsonIgnore
    public boolean formData() {
        return List.of(MediaType.MIME_MULTIPART_FORM_DATA.getCode(), MediaType.MIME_FORM_URLENCODED.getCode()).contains(this.getMediaType());
    }

    @JsonIgnore
    public boolean objectData() {
        return List.of(MediaType.MIME_JSON_UTF8.getCode(), MediaType.MIME_TEXT_PLAIN.getCode()).contains(this.getMediaType());
    }

    @JsonIgnore
    public BodyInserters.FormInserter<String> getBodyFormData() {
        MultiValueMap formData = (MultiValueMap)BeanUtils.toBean((String)JSONUtil.toJsonStr((Object)this.getBodyParam()), (TypeReference)new TypeReference<MultiValueMap<String, String>>(){});
        return BodyInserters.fromFormData((MultiValueMap)formData);
    }

    HttpParam(String bizKey, String url, String authMethod, HttpMethod requestMethod, String mediaType, InfinityApiDetailVO apiConfig, MultiValueMap<String, String> headerParam, MultiValueMap<String, String> queryParam, Map<String, String> pathParam, Object bodyParam) {
        this.bizKey = bizKey;
        this.url = url;
        this.authMethod = authMethod;
        this.requestMethod = requestMethod;
        this.mediaType = mediaType;
        this.apiConfig = apiConfig;
        this.headerParam = headerParam;
        this.queryParam = queryParam;
        this.pathParam = pathParam;
        this.bodyParam = bodyParam;
    }

    public static HttpParamBuilder builder() {
        return new HttpParamBuilder();
    }

    public String getBizKey() {
        return this.bizKey;
    }

    public InfinityApiDetailVO getApiConfig() {
        return this.apiConfig;
    }

    public MultiValueMap<String, String> getHeaderParam() {
        return this.headerParam;
    }

    public MultiValueMap<String, String> getQueryParam() {
        return this.queryParam;
    }

    public Map<String, String> getPathParam() {
        return this.pathParam;
    }

    public Object getBodyParam() {
        return this.bodyParam;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setRequestMethod(HttpMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setApiConfig(InfinityApiDetailVO apiConfig) {
        this.apiConfig = apiConfig;
    }

    public void setHeaderParam(MultiValueMap<String, String> headerParam) {
        this.headerParam = headerParam;
    }

    public void setQueryParam(MultiValueMap<String, String> queryParam) {
        this.queryParam = queryParam;
    }

    public void setPathParam(Map<String, String> pathParam) {
        this.pathParam = pathParam;
    }

    public void setBodyParam(Object bodyParam) {
        this.bodyParam = bodyParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpParam)) {
            return false;
        }
        HttpParam other = (HttpParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bizKey = this.getBizKey();
        String other$bizKey = other.getBizKey();
        if (this$bizKey == null ? other$bizKey != null : !this$bizKey.equals(other$bizKey)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$authMethod = this.getAuthMethod();
        String other$authMethod = other.getAuthMethod();
        if (this$authMethod == null ? other$authMethod != null : !this$authMethod.equals(other$authMethod)) {
            return false;
        }
        HttpMethod this$requestMethod = this.getRequestMethod();
        HttpMethod other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        InfinityApiDetailVO this$apiConfig = this.getApiConfig();
        InfinityApiDetailVO other$apiConfig = other.getApiConfig();
        if (this$apiConfig == null ? other$apiConfig != null : !((Object)this$apiConfig).equals(other$apiConfig)) {
            return false;
        }
        MultiValueMap<String, String> this$headerParam = this.getHeaderParam();
        MultiValueMap<String, String> other$headerParam = other.getHeaderParam();
        if (this$headerParam == null ? other$headerParam != null : !this$headerParam.equals(other$headerParam)) {
            return false;
        }
        MultiValueMap<String, String> this$queryParam = this.getQueryParam();
        MultiValueMap<String, String> other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !this$queryParam.equals(other$queryParam)) {
            return false;
        }
        Map<String, String> this$pathParam = this.getPathParam();
        Map<String, String> other$pathParam = other.getPathParam();
        if (this$pathParam == null ? other$pathParam != null : !((Object)this$pathParam).equals(other$pathParam)) {
            return false;
        }
        Object this$bodyParam = this.getBodyParam();
        Object other$bodyParam = other.getBodyParam();
        return !(this$bodyParam == null ? other$bodyParam != null : !this$bodyParam.equals(other$bodyParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bizKey = this.getBizKey();
        result = result * 59 + ($bizKey == null ? 43 : $bizKey.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $authMethod = this.getAuthMethod();
        result = result * 59 + ($authMethod == null ? 43 : $authMethod.hashCode());
        HttpMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        InfinityApiDetailVO $apiConfig = this.getApiConfig();
        result = result * 59 + ($apiConfig == null ? 43 : ((Object)$apiConfig).hashCode());
        MultiValueMap<String, String> $headerParam = this.getHeaderParam();
        result = result * 59 + ($headerParam == null ? 43 : $headerParam.hashCode());
        MultiValueMap<String, String> $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : $queryParam.hashCode());
        Map<String, String> $pathParam = this.getPathParam();
        result = result * 59 + ($pathParam == null ? 43 : ((Object)$pathParam).hashCode());
        Object $bodyParam = this.getBodyParam();
        result = result * 59 + ($bodyParam == null ? 43 : $bodyParam.hashCode());
        return result;
    }

    public String toString() {
        return "HttpParam(bizKey=" + this.getBizKey() + ", url=" + this.getUrl() + ", authMethod=" + this.getAuthMethod() + ", requestMethod=" + this.getRequestMethod() + ", mediaType=" + this.getMediaType() + ", apiConfig=" + this.getApiConfig() + ", headerParam=" + this.getHeaderParam() + ", queryParam=" + this.getQueryParam() + ", pathParam=" + this.getPathParam() + ", bodyParam=" + this.getBodyParam() + ")";
    }

    public static class HttpParamBuilder {
        private String bizKey;
        private String url;
        private String authMethod;
        private HttpMethod requestMethod;
        private String mediaType;
        private InfinityApiDetailVO apiConfig;
        private MultiValueMap<String, String> headerParam;
        private MultiValueMap<String, String> queryParam;
        private Map<String, String> pathParam;
        private Object bodyParam;

        HttpParamBuilder() {
        }

        public HttpParamBuilder bizKey(String bizKey) {
            this.bizKey = bizKey;
            return this;
        }

        public HttpParamBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpParamBuilder authMethod(String authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public HttpParamBuilder requestMethod(HttpMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public HttpParamBuilder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public HttpParamBuilder apiConfig(InfinityApiDetailVO apiConfig) {
            this.apiConfig = apiConfig;
            return this;
        }

        public HttpParamBuilder headerParam(MultiValueMap<String, String> headerParam) {
            this.headerParam = headerParam;
            return this;
        }

        public HttpParamBuilder queryParam(MultiValueMap<String, String> queryParam) {
            this.queryParam = queryParam;
            return this;
        }

        public HttpParamBuilder pathParam(Map<String, String> pathParam) {
            this.pathParam = pathParam;
            return this;
        }

        public HttpParamBuilder bodyParam(Object bodyParam) {
            this.bodyParam = bodyParam;
            return this;
        }

        public HttpParam build() {
            return new HttpParam(this.bizKey, this.url, this.authMethod, this.requestMethod, this.mediaType, this.apiConfig, this.headerParam, this.queryParam, this.pathParam, this.bodyParam);
        }

        public String toString() {
            return "HttpParam.HttpParamBuilder(bizKey=" + this.bizKey + ", url=" + this.url + ", authMethod=" + this.authMethod + ", requestMethod=" + this.requestMethod + ", mediaType=" + this.mediaType + ", apiConfig=" + this.apiConfig + ", headerParam=" + this.headerParam + ", queryParam=" + this.queryParam + ", pathParam=" + this.pathParam + ", bodyParam=" + this.bodyParam + ")";
        }
    }
}

