/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.api.domain.FormColumnDefinition;
import com.elitesland.cbpl.infinity.server.api.service.InfinityApiService;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.logging.infinity.domain.InfinityLogVO;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

public class InfinityRestClient {
    private static final Logger logger = LoggerFactory.getLogger(InfinityRestClient.class);
    private final WebClient webClient;
    @Resource
    private InfinityApiService infinityApiService;
    @Resource
    private SecurityAuthService securityAuthService;

    public InfinityResult<String> exchange(String apiCode) {
        return this.exchange(apiCode, String.class, null);
    }

    public <R> InfinityResult<R> exchange(String apiCode, Class<R> responseType) {
        return this.exchange(apiCode, responseType, null);
    }

    public InfinityResult<String> exchange(String apiCode, Function<HttpParam.HttpParamBuilder, HttpParam> func) {
        return this.exchange(apiCode, String.class, func);
    }

    public <R> InfinityResult<R> exchange(String apiCode, Class<R> responseType, Function<HttpParam.HttpParamBuilder, HttpParam> fn) {
        InfinityLogVO logVO = new InfinityLogVO();
        HttpParam.HttpParamBuilder builder = HttpParam.builder().apiConfig(this.infinityApiService.infinityApiByApiCode(apiCode));
        HttpParam param = fn != null ? fn.apply(builder) : builder.build();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)param.getUrl());
        logVO.setServerUrl(param.getApiConfig().getServerUrl());
        logVO.setApiUrl(param.getApiConfig().getApiUrl());
        logVO.setUri(param.getUrl());
        List<FormColumnDefinition> queryConfig = param.getApiConfig().getQueryParam();
        if (CollUtil.isNotEmpty(queryConfig)) {
            queryConfig.stream().filter(def -> StrUtil.isNotBlank((CharSequence)def.getFixedValue())).forEach(def -> {
                uriBuilder.queryParam(def.getColumnKey(), new Object[]{def.getFixedValue()});
                logVO.addQueryParam(def.getColumnKey(), new Object[]{def.getFixedValue()});
            });
        }
        if (MapUtil.isNotEmpty(param.getQueryParam())) {
            uriBuilder.queryParams(param.getQueryParam());
            logVO.addQueryParams(param.getQueryParam());
        }
        WebClient.RequestBodyUriSpec method = this.webClient.method(param.getRequestMethod());
        WebClient.RequestBodySpec uri = MapUtil.isEmpty(param.getPathParam()) ? (WebClient.RequestBodySpec)method.uri(uriBuilder.toUriString(), new Object[0]) : (WebClient.RequestBodySpec)method.uri(uriBuilder.build(false).toUriString(), param.getPathParam());
        uri.acceptCharset(new Charset[]{StandardCharsets.UTF_8});
        logVO.setRequestMethod(param.getRequestMethod());
        UnicomClient.supply(() -> this.securityAuthService.authentication(uri, param), (String)param.getAuthMethod());
        uri.headers(headers -> {
            MultiValueMap<String, String> headerParam;
            List<FormColumnDefinition> headerConfig = param.getApiConfig().getHeaderParam();
            if (CollUtil.isNotEmpty(headerConfig)) {
                headerConfig.stream().filter(def -> StrUtil.isNotBlank((CharSequence)def.getFixedValue())).forEach(def -> headers.set(def.getColumnKey(), def.getFixedValue()));
            }
            if (MapUtil.isNotEmpty(headerParam = param.getHeaderParam())) {
                for (String key : headerParam.keySet()) {
                    headers.set(key, (String)headerParam.getFirst((Object)key));
                }
            }
            logVO.setHeaderParam((MultiValueMap)headers);
        });
        if (param.needBodyParam()) {
            uri.contentType(MediaType.parseMediaType((String)param.getMediaType()));
            if (param.formData()) {
                uri.body(param.getBodyFormData());
                logVO.setBodyParam(param.getBodyFormData());
            } else if (param.objectData()) {
                uri.bodyValue(param.getBodyParam());
                logVO.setBodyParam(param.getBodyParam());
            }
        }
        return InfinityResult.of(responseType, param, logVO, uri);
    }

    public InfinityRestClient(WebClient webClient) {
        this.webClient = webClient;
    }
}

