package com.elitesland.cbpl.infinity.server.account.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 对外提供接口的认证账号
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_infinity_account")
@org.hibernate.annotations.Table(appliesTo = "sys_infinity_account", comment = "对外提供接口的认证账号")
@ApiModel("对外提供接口的认证账号")
public class InfinityAccountDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 990846881582855895L;

	/**
	 * 所属租户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属租户")
	@Column(name = "belong_tenant", nullable = true, length = 20)
	private Long belongTenant;

	/**
	 * 认证账号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "认证账号")
	@Column(name = "username", nullable = true, length = 64)
	private String username;

	/**
	 * 认证密码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "认证密码")
	@Column(name = "password", nullable = true, length = 64)
	private String password;

	/**
	 * 拦截地址：逗号分隔
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "拦截地址：逗号分隔")
	@Column(name = "intercept_uri", nullable = true, length = 255)
	private String interceptUri;

	/**
	 * 平台编码：wms、boh、美团、旺店通等
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "平台编码：wms、boh、美团、旺店通等")
	@Column(name = "platform_code", nullable = true, length = 64)
	private String platformCode;

	/**
	 * 自定义标签
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "自定义标签")
	@Column(name = "tags", nullable = true, length = 255)
	private String tags;
}
