package com.elitesland.cbpl.infinity.server.account.service.impl;

import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.infinity.server.account.convert.InfinityAccountConvert;
import com.elitesland.cbpl.infinity.server.account.entity.InfinityAccountDO;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepo;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepoProc;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountPagingParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountSaveParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountDetailVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountPagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityAccountServiceImpl implements InfinityAccountService {

    private final InfinityAccountRepo infinityAccountRepo;
    private final InfinityAccountRepoProc infinityAccountRepoProc;

    @Override
    public PagingVO<InfinityAccountPagingVO> infinityAccountPageBy(InfinityAccountPagingParamVO query) {
        long count = infinityAccountRepoProc.infinityAccountCountBy(query);
        if (count > 0) {
            var list = infinityAccountRepoProc.infinityAccountPageBy(query);
            return new PagingVO<>(count, list);
        }
        return new PagingVO<>();
    }

    @Override
    public List<InfinityAccountRespVO> infinityAccountByParam(InfinityAccountQueryParamVO query) {
        return infinityAccountRepoProc.infinityAccountByParam(query);
    }

    @Override
    public InfinityAccountDetailVO infinityAccountById(Long id) {
        Optional<InfinityAccountDO> infinityAccountDO = infinityAccountRepo.findById(id);
        if (infinityAccountDO.isEmpty()) {
            throw PhoenixException.unexpected("Not Found Data");
        }
        return InfinityAccountConvert.INSTANCE.doToVO(infinityAccountDO.get());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long create(InfinityAccountSaveParamVO saveParam) {
        InfinityAccountDO infinityAccountDO = InfinityAccountConvert.INSTANCE.saveParamToDO(saveParam);
        // TODO 业务单据编码发号器
        // var bizCode = seqNumProvider.generateCode("appCode", "ruleCode", Collections.emptyList());
        infinityAccountRepo.save(infinityAccountDO);
        return infinityAccountDO.getId();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long update(InfinityAccountSaveParamVO saveParam) {
        Assert.notNull(saveParam.getId(), "Missing Primary Key");
        Optional<InfinityAccountDO> infinityAccountDO = infinityAccountRepo.findById(saveParam.getId());
        if (infinityAccountDO.isEmpty()) {
            throw PhoenixException.unexpected("Not Found Data");
        }
        InfinityAccountDO infinityAccount = infinityAccountDO.get();
        InfinityAccountConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityAccount);
        infinityAccountRepo.save(infinityAccount);
        return infinityAccount.getId();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long save(InfinityAccountSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            InfinityAccountDO infinityAccountDO = InfinityAccountConvert.INSTANCE.saveParamToDO(saveParam);
            // TODO 业务单据编码发号器
            // var bizCode = seqNumProvider.generateCode("appCode", "ruleCode", Collections.emptyList());
            infinityAccountRepo.save(infinityAccountDO);
            return infinityAccountDO.getId();
        }
        // 修改
        else {
            Optional<InfinityAccountDO> infinityAccountDO = infinityAccountRepo.findById(saveParam.getId());
            if (infinityAccountDO.isEmpty()) {
                throw PhoenixException.unexpected("Not Found Data");
            }
            InfinityAccountDO infinityAccount = infinityAccountDO.get();
            InfinityAccountConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityAccount);
            infinityAccountRepo.save(infinityAccount);
            return infinityAccount.getId();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(Long id, String status) {
        // TODO Update status based on business.
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long delete(List<Long> ids) {
        return infinityAccountRepoProc.delete(ids);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long updateDeleteFlag(List<Long> ids) {
        return infinityAccountRepoProc.updateDeleteFlag(ids);
    }
}
