package com.elitesland.cbpl.infinity.server.account.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 对外提供接口的认证账号
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("对外提供接口的认证账号")
public class InfinityAccountRespVO {

	@ApiModelProperty(value = "唯一标识")
	private Long id;

	@ApiModelProperty(value = "所属租户")
	private Long belongTenant;

	@ApiModelProperty(value = "认证账号")
	private String username;

	@ApiModelProperty(value = "认证密码")
	private String password;

	@ApiModelProperty(value = "拦截地址：逗号分隔")
	private String interceptUri;

	@ApiModelProperty(value = "平台编码：wms、boh、美团、旺店通等")
	private String platformCode;

	@ApiModelProperty(value = "自定义标签")
	private String tags;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者id")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者id")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
