package com.elitesland.cbpl.infinity.server.api.domain;

import com.elitesland.cbpl.infinity.common.constant.DataType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/17
 */
@Data
@ApiModel("表单参数")
public class FormColumnDefinition {

    @ApiModelProperty("字段")
    private String columnKey;

    @ApiModelProperty("字段中文")
    private String columnName;

    @ApiModelProperty("数据类型")
    private DataType dataType;

    @ApiModelProperty("描述说明：默认值、注意事项等")
    private String description;

    @ApiModelProperty("是否必填")
    private boolean required;

    @ApiModelProperty("固定值")
    private String fixedValue;

    @ApiModelProperty("子集，数据类型为对象或数组时有数据")
    private List<FormColumnDefinition> children;
}
