package com.elitesland.cbpl.infinity.server.folder.controller;

import com.elitesland.cbpl.infinity.server.folder.service.InfinityFolderService;
import com.elitesland.cbpl.infinity.server.folder.vo.param.FolderSaveParamVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Slf4j
@Api(tags = "接口分组")
@RestController
@RequestMapping("/infinity/server/folder")
@AllArgsConstructor
public class InfinityFolderController {

    private final InfinityFolderService folderService;

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public HttpResult<Long> save(@RequestBody @Valid FolderSaveParamVO saveParam) {
        logger.info("[InfinityFolder] create/update record, saveParam = {}", saveParam);
        return HttpResult.ok(folderService.save(saveParam));
    }

    @ApiOperation(value = "批量物理删除")
    @DeleteMapping(value = "/delete")
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[InfinityFolder] batch physical delete by ids = {}", ids);
        folderService.delete(ids);
        return HttpResult.ok();
    }
}
