package com.elitesland.cbpl.infinity.server.folder.service.impl;

import com.elitesland.cbpl.infinity.server.folder.convert.InfinityFolderConvert;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.repo.InfinityFolderRepo;
import com.elitesland.cbpl.infinity.server.folder.repo.InfinityFolderRepoProc;
import com.elitesland.cbpl.infinity.server.folder.service.InfinityFolderService;
import com.elitesland.cbpl.infinity.server.folder.vo.param.FolderSaveParamVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityFolderServiceImpl implements InfinityFolderService {

    private final InfinityFolderRepo folderRepo;
    private final InfinityFolderRepoProc folderRepoProc;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long save(FolderSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            // TODO 目录名称唯一
            InfinityFolderDO infinityFolderDO = InfinityFolderConvert.INSTANCE.saveParamToDO(saveParam);
            folderRepo.save(infinityFolderDO);
            return infinityFolderDO.getId();
        }
        // 修改
        else {
            Optional<InfinityFolderDO> infinityFolderDO = folderRepo.findById(saveParam.getId());
            if (infinityFolderDO.isEmpty()) {
                throw PhoenixException.unexpected("Not Found Data");
            }
            InfinityFolderDO infinityFolder = infinityFolderDO.get();
            InfinityFolderConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityFolder);
            folderRepo.save(infinityFolder);
            return infinityFolder.getId();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long delete(List<Long> ids) {
        // TODO 删除该目录下，所有接口
        return folderRepoProc.delete(ids);
    }
}
