package com.elitesland.cbpl.infinity.server.platform.controller;

import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformSaveParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Slf4j
@Api(tags = "接口平台(对接系统)")
@RestController
@RequestMapping("/infinity/server/platform")
@AllArgsConstructor
public class InfinityPlatformController {

    private final InfinityPlatformService platformService;

    @ApiOperation(value = "不分页查询")
    @PostMapping(value = "/query")
    public HttpResult<List<PlatformRespVO>> query(@RequestBody PlatformQueryParamVO query) {
        logger.info("[InfinityPlatform] query list param = {}", query);
        return HttpResult.ok(platformService.platformByParam(query));
    }

    @ApiOperation(value = "明细查询")
    @GetMapping(value = "/detail/{id}")
    public HttpResult<PlatformRespVO> detail(@PathVariable("id") Long id) {
        logger.info("[InfinityPlatform] query detail by id = {}", id);
        return HttpResult.ok(platformService.platformById(id));
    }

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public HttpResult<Long> save(@RequestBody @Valid PlatformSaveParamVO saveParam) {
        logger.info("[InfinityPlatform] create/update record, saveParam = {}", saveParam);
        return HttpResult.ok(platformService.save(saveParam));
    }

    @ApiOperation(value = "批量物理删除[需要提示，请谨慎操作]")
    @DeleteMapping(value = "/delete")
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[InfinityPlatform] batch physical delete by ids = {}", ids);
        platformService.delete(ids);
        return HttpResult.ok();
    }
}
