package com.elitesland.cbpl.infinity.server.platform.service;

import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformPagingParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformSaveParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformPagingVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
public interface InfinityPlatformService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<PlatformPagingVO> platformPageBy(PlatformPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<PlatformRespVO> platformByParam(PlatformQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    PlatformRespVO platformById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(PlatformSaveParamVO saveParam);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);
}
