package com.elitesland.cbpl.infinity.web.http.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author eric.hao
 * @since 2024/05/20
 */
@Slf4j
@Api(tags = "接口调用")
@RestController
@RequestMapping("/infinity/web")
@RequiredArgsConstructor
public class InfinityWebController {

    private final InfinityRestClient restClient;

    @ApiOperation(value = "执行一次")
    @PostMapping("/invoke/{apiCode}")
    public Object sync(HttpServletRequest request, @PathVariable("apiCode") String apiCode, @RequestBody Object payload) {
        var headerParam = HttpServletUtil.getHeaders(request);
        var queryParam = HttpServletUtil.getQueryParameters(request);
        InfinityResult<Object> resp = restClient.exchange(apiCode, Object.class, (builder) -> {
            // TODO 待优化
//            if (MapUtil.isNotEmpty(headerParam)) {
//                builder.headerParam(headerParam);
//            }
            if (MapUtil.isNotEmpty(queryParam)) {
                builder.queryParam(queryParam);
            }
            if (ObjectUtil.isNotNull(payload)) {
                builder.bodyParam(payload);
            }
            return builder.build();
        });
        return resp.toEntity();
    }
}
