package com.elitesland.cbpl.infinity.web.security.service.inherit;

import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * `@UnicomTag` 参考 {@link AuthMethod}
 *
 * @author eric.hao
 * @since 2024/06/07
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("INHERIT")
public class InheritSecurityService implements SecurityAuthService {

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info("[BPMN][INFINITY] Auth Method: " + AuthMethod.AUTH_METHOD_INHERIT.getDesc());
        return true;
    }
}
