/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.account.service.impl;

import com.elitesland.cbpl.infinity.server.account.convert.InfinityAccountConvert;
import com.elitesland.cbpl.infinity.server.account.entity.InfinityAccountDO;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepo;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepoProc;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountPagingParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountSaveParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountDetailVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountPagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InfinityAccountServiceImpl
implements InfinityAccountService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityAccountServiceImpl.class);
    private final InfinityAccountRepo infinityAccountRepo;
    private final InfinityAccountRepoProc infinityAccountRepoProc;

    @Override
    public PagingVO<InfinityAccountPagingVO> infinityAccountPageBy(InfinityAccountPagingParamVO query) {
        long count = this.infinityAccountRepoProc.infinityAccountCountBy(query);
        if (count > 0L) {
            List<InfinityAccountPagingVO> list = this.infinityAccountRepoProc.infinityAccountPageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<InfinityAccountRespVO> infinityAccountByParam(InfinityAccountQueryParamVO query) {
        return this.infinityAccountRepoProc.infinityAccountByParam(query);
    }

    @Override
    public InfinityAccountDetailVO infinityAccountById(Long id) {
        Optional infinityAccountDO = this.infinityAccountRepo.findById(id);
        if (infinityAccountDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return InfinityAccountConvert.INSTANCE.doToVO((InfinityAccountDO)infinityAccountDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long create(InfinityAccountSaveParamVO saveParam) {
        InfinityAccountDO infinityAccountDO = InfinityAccountConvert.INSTANCE.saveParamToDO(saveParam);
        this.infinityAccountRepo.save(infinityAccountDO);
        return infinityAccountDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(InfinityAccountSaveParamVO saveParam) {
        Assert.notNull((Object)saveParam.getId(), (String)"Missing Primary Key");
        Optional infinityAccountDO = this.infinityAccountRepo.findById(saveParam.getId());
        if (infinityAccountDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinityAccountDO infinityAccount = (InfinityAccountDO)infinityAccountDO.get();
        InfinityAccountConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityAccount);
        this.infinityAccountRepo.save(infinityAccount);
        return infinityAccount.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(InfinityAccountSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            InfinityAccountDO infinityAccountDO = InfinityAccountConvert.INSTANCE.saveParamToDO(saveParam);
            this.infinityAccountRepo.save(infinityAccountDO);
            return infinityAccountDO.getId();
        }
        Optional infinityAccountDO = this.infinityAccountRepo.findById(saveParam.getId());
        if (infinityAccountDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinityAccountDO infinityAccount = (InfinityAccountDO)infinityAccountDO.get();
        InfinityAccountConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityAccount);
        this.infinityAccountRepo.save(infinityAccount);
        return infinityAccount.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, String status) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.infinityAccountRepoProc.delete(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(List<Long> ids) {
        return this.infinityAccountRepoProc.updateDeleteFlag(ids);
    }

    public InfinityAccountServiceImpl(InfinityAccountRepo infinityAccountRepo, InfinityAccountRepoProc infinityAccountRepoProc) {
        this.infinityAccountRepo = infinityAccountRepo;
        this.infinityAccountRepoProc = infinityAccountRepoProc;
    }
}

