package com.elitesland.cbpl.infinity.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @since 2024/05/17
 */
@Getter
public enum DataType {

    Object("object"),

    Array("array"),

    Any("object"),

    Boolean("boolean"),

    String("string"),

    Date("date"),

    Number("number"),
    ;

    private final String desc;

    public String getCode() {
        return this.name().toLowerCase();
    }

    DataType(String desc) {
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (DataType status : DataType.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }
}
