/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.platform.repo;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.platform.entity.InfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.entity.QInfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformPagingParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformPagingVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class InfinityPlatformRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityPlatformDO platformDO = QInfinityPlatformDO.infinityPlatformDO;
    private final QBean<PlatformPagingVO> platformPagingVO;
    private final QBean<PlatformRespVO> platformVO;

    private Predicate pagingWhere(PlatformPagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(InfinityPlatformRepoProc.platformDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getPlatformCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getPlatformCodeName());
            predicates.add(InfinityPlatformRepoProc.platformDO.platformCode.eq((Object)likeStr).or((Predicate)InfinityPlatformRepoProc.platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getServerUrl())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getServerUrl());
            predicates.add(InfinityPlatformRepoProc.platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long platformCountBy(PlatformPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(InfinityPlatformRepoProc.platformDO.id).from((EntityPath)platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<InfinityPlatformDO> platformPageBy(PlatformPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)platformDO).from((EntityPath)platformDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(PlatformQueryParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(InfinityPlatformRepoProc.platformDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getPlatformCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getPlatformCodeName());
            predicates.add(InfinityPlatformRepoProc.platformDO.platformCode.eq((Object)likeStr).or((Predicate)InfinityPlatformRepoProc.platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getServerUrl())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getServerUrl());
            predicates.add(InfinityPlatformRepoProc.platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityPlatformDO> platformByParam(PlatformQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)platformDO).from((EntityPath)platformDO);
        jpaQuery.orderBy(new OrderSpecifier(Order.ASC, (Expression)InfinityPlatformRepoProc.platformDO.platformName));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)platformDO).where(new Predicate[]{InfinityPlatformRepoProc.platformDO.id.in(ids)});
        return delete.execute();
    }

    public InfinityPlatformRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.platformPagingVO = Projections.bean(PlatformPagingVO.class, (Expression[])new Expression[]{InfinityPlatformRepoProc.platformDO.id, InfinityPlatformRepoProc.platformDO.platformName, InfinityPlatformRepoProc.platformDO.platformCode, InfinityPlatformRepoProc.platformDO.serverUrl, InfinityPlatformRepoProc.platformDO.authMethod, InfinityPlatformRepoProc.platformDO.description, InfinityPlatformRepoProc.platformDO.remark, InfinityPlatformRepoProc.platformDO.createUserId, InfinityPlatformRepoProc.platformDO.creator, InfinityPlatformRepoProc.platformDO.createTime, InfinityPlatformRepoProc.platformDO.modifyUserId, InfinityPlatformRepoProc.platformDO.updater, InfinityPlatformRepoProc.platformDO.modifyTime});
        this.platformVO = Projections.bean(PlatformRespVO.class, (Expression[])new Expression[]{InfinityPlatformRepoProc.platformDO.id, InfinityPlatformRepoProc.platformDO.platformName, InfinityPlatformRepoProc.platformDO.platformCode, InfinityPlatformRepoProc.platformDO.serverUrl, InfinityPlatformRepoProc.platformDO.authMethod, InfinityPlatformRepoProc.platformDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

