/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.oauth2;

import com.elitesland.cbpl.infinity.web.security.service.oauth2.AccessToken;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Client {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Client.class);
    private final RestWrapper restWrapper;

    public String getAccessToken(String url, String clientId, String clientSecret) {
        AccessToken token = this.authentication(url, clientId, clientSecret, AccessToken.class);
        String accessToken = token.getAccessToken();
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken));
        return accessToken;
    }

    public String authentication(String url, String clientId, String clientSecret) {
        String accessToken = this.authentication(url, clientId, clientSecret, String.class);
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken));
        return accessToken;
    }

    public <T> T authentication(String url, String clientId, String clientSecret, Class<T> clazz) {
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 Url: " + url));
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 clientId: " + clientId));
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("grant_type", "client_credentials");
            param.put("client_id", clientId);
            param.put("client_secret", clientSecret);
            String result = this.restWrapper.postFormUrlencoded(url, param);
            return (T)BeanUtils.toBean((String)result, clazz);
        }
        catch (Exception e) {
            LogUtil.error((String)"[BPMN][INFINITY] OAuth2 invoke error", (String)ExceptionUtils.formatException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public OAuth2Client(RestWrapper restWrapper) {
        this.restWrapper = restWrapper;
    }
}

