/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.api.controller;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.infinity.server.api.service.InfinityApiService;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiQueryParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiSaveParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiDetailVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a5\u53e3\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/infinity/server/api"})
public class InfinityApiController {
    private static final Logger logger = LoggerFactory.getLogger(InfinityApiController.class);
    private final InfinityApiService apiService;

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public HttpResult<List<InfinityApiRespVO>> query(@RequestBody @Valid ApiQueryParamVO query) {
        logger.info("[InfinityApi] query list param = {}", (Object)query);
        return HttpResult.ok(this.apiService.infinityApiByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<InfinityApiDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[InfinityApi] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.apiService.infinityApiById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody @Valid ApiSaveParamVO saveParam) {
        logger.info("[InfinityApi] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.apiService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[InfinityApi] active by id = {}", (Object)id);
        this.apiService.updateStatus(id, ActiveStatus.ACTIVE.getCode());
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[InfinityApi] inactive by id = {}", (Object)id);
        this.apiService.updateStatus(id, ActiveStatus.INACTIVE.getCode());
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Long> delete(@RequestBody List<Long> ids) {
        logger.info("[InfinityApi] batch physical delete by ids = {}", ids);
        return HttpResult.ok((Object)this.apiService.delete(ids));
    }

    public InfinityApiController(InfinityApiService apiService) {
        this.apiService = apiService;
    }
}

