/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.api.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.api.entity.QInfinityApiDO;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiQueryParamVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiMergeVO;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;
import com.elitesland.cbpl.infinity.server.folder.entity.QInfinityFolderDO;
import com.elitesland.cbpl.infinity.server.platform.entity.QInfinityPlatformDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class InfinityApiRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityApiDO infinityApiDO = QInfinityApiDO.infinityApiDO;
    private static final QInfinityFolderDO folderDO = QInfinityFolderDO.infinityFolderDO;
    private static final QInfinityPlatformDO platformDO = QInfinityPlatformDO.infinityPlatformDO;
    private final QBean<InfinityApiRespVO> infinityApiVO;

    private Predicate where(ApiQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(InfinityApiRepoProc.infinityApiDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getPlatformCode())) {
            predicates.add(InfinityApiRepoProc.infinityApiDO.platformCode.eq((Object)query.getPlatformCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityApiRespVO> infinityApiByParam(ApiQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.infinityApiVO).from((EntityPath)infinityApiDO)).leftJoin((EntityPath)folderDO)).on((Predicate)InfinityApiRepoProc.folderDO.id.eq(InfinityApiRepoProc.infinityApiDO.folderId));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)infinityApiDO).where(new Predicate[]{InfinityApiRepoProc.infinityApiDO.id.in(ids)});
        return delete.execute();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)infinityApiDO).set(InfinityApiRepoProc.infinityApiDO.deleteFlag, (Object)1).where(new Predicate[]{InfinityApiRepoProc.infinityApiDO.id.in(ids)});
        return update.execute();
    }

    public long updateStatus(Long id, int status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)infinityApiDO).set(InfinityApiRepoProc.infinityApiDO.apiStatus, (Object)status).where(new Predicate[]{InfinityApiRepoProc.infinityApiDO.id.eq((Object)id)});
        return update.execute();
    }

    public InfinityApiMergeVO findByApiCode(String apiCode) {
        if (StrUtil.isBlank((CharSequence)apiCode)) {
            return null;
        }
        QBean infinityApiVO = Projections.bean(InfinityApiMergeVO.class, (Expression[])new Expression[]{InfinityApiRepoProc.infinityApiDO.id, InfinityApiRepoProc.infinityApiDO.platformCode, InfinityApiRepoProc.folderDO.id.as("folderId"), InfinityApiRepoProc.infinityApiDO.serverUrl.as("apiServerUrl"), InfinityApiRepoProc.infinityApiDO.authMethod.as("apiAuthMethod"), InfinityApiRepoProc.infinityApiDO.authAccount.as("apiAuthAccount"), InfinityApiRepoProc.folderDO.serverUrl.as("folderServerUrl"), InfinityApiRepoProc.folderDO.authMethod.as("folderAuthMethod"), InfinityApiRepoProc.folderDO.authAccount.as("folderAuthAccount"), InfinityApiRepoProc.platformDO.serverUrl.as("platformServerUrl"), InfinityApiRepoProc.platformDO.authMethod.as("platformAuthMethod"), InfinityApiRepoProc.platformDO.authAccount.as("platformAuthAccount"), InfinityApiRepoProc.infinityApiDO.apiCode, InfinityApiRepoProc.infinityApiDO.apiName, InfinityApiRepoProc.infinityApiDO.apiUrl, InfinityApiRepoProc.infinityApiDO.requestMethod, InfinityApiRepoProc.infinityApiDO.apiStatus, InfinityApiRepoProc.infinityApiDO.headerParam, InfinityApiRepoProc.infinityApiDO.queryParam, InfinityApiRepoProc.infinityApiDO.pathParam, InfinityApiRepoProc.infinityApiDO.mediaType, InfinityApiRepoProc.infinityApiDO.bodyParam, InfinityApiRepoProc.infinityApiDO.response, InfinityApiRepoProc.infinityApiDO.responseSuccessSpel, InfinityApiRepoProc.infinityApiDO.responseSuccessStatus, InfinityApiRepoProc.infinityApiDO.responseErrorMessageSpel, InfinityApiRepoProc.infinityApiDO.description, InfinityApiRepoProc.infinityApiDO.remark, InfinityApiRepoProc.infinityApiDO.createUserId, InfinityApiRepoProc.infinityApiDO.creator, InfinityApiRepoProc.infinityApiDO.createTime, InfinityApiRepoProc.infinityApiDO.modifyUserId, InfinityApiRepoProc.infinityApiDO.updater, InfinityApiRepoProc.infinityApiDO.modifyTime, InfinityApiRepoProc.infinityApiDO.deleteFlag});
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)infinityApiVO).from((EntityPath)infinityApiDO)).leftJoin((EntityPath)folderDO)).on((Predicate)InfinityApiRepoProc.folderDO.id.eq(InfinityApiRepoProc.infinityApiDO.folderId))).leftJoin((EntityPath)platformDO)).on((Predicate)InfinityApiRepoProc.platformDO.platformCode.eq((Expression)InfinityApiRepoProc.infinityApiDO.platformCode));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(InfinityApiRepoProc.infinityApiDO.apiCode.eq((Object)apiCode));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return (InfinityApiMergeVO)jpaQuery.fetchOne();
    }

    public boolean existsByCode(Long id, String apiCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(InfinityApiRepoProc.infinityApiDO.apiCode.eq((Object)apiCode));
        if (ObjectUtil.isNotNull((Object)id)) {
            predicates.add(InfinityApiRepoProc.infinityApiDO.id.ne((Object)id));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(InfinityApiRepoProc.infinityApiDO.id).from((EntityPath)infinityApiDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }

    public InfinityApiRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.infinityApiVO = Projections.bean(InfinityApiRespVO.class, (Expression[])new Expression[]{InfinityApiRepoProc.infinityApiDO.id, InfinityApiRepoProc.infinityApiDO.platformCode, InfinityApiRepoProc.infinityApiDO.folderId, InfinityApiRepoProc.folderDO.folderName, InfinityApiRepoProc.infinityApiDO.serverUrl, InfinityApiRepoProc.infinityApiDO.authMethod, InfinityApiRepoProc.infinityApiDO.authAccount, InfinityApiRepoProc.infinityApiDO.apiCode, InfinityApiRepoProc.infinityApiDO.apiName, InfinityApiRepoProc.infinityApiDO.apiUrl, InfinityApiRepoProc.infinityApiDO.requestMethod, InfinityApiRepoProc.infinityApiDO.apiStatus, InfinityApiRepoProc.infinityApiDO.headerParam, InfinityApiRepoProc.infinityApiDO.queryParam, InfinityApiRepoProc.infinityApiDO.pathParam, InfinityApiRepoProc.infinityApiDO.bodyParam, InfinityApiRepoProc.infinityApiDO.response, InfinityApiRepoProc.infinityApiDO.description, InfinityApiRepoProc.infinityApiDO.remark, InfinityApiRepoProc.infinityApiDO.createUserId, InfinityApiRepoProc.infinityApiDO.creator, InfinityApiRepoProc.infinityApiDO.createTime, InfinityApiRepoProc.infinityApiDO.modifyUserId, InfinityApiRepoProc.infinityApiDO.updater, InfinityApiRepoProc.infinityApiDO.modifyTime, InfinityApiRepoProc.infinityApiDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

