/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.folder.service.impl;

import com.elitesland.cbpl.infinity.server.folder.convert.InfinityFolderConvert;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.repo.InfinityFolderRepo;
import com.elitesland.cbpl.infinity.server.folder.repo.InfinityFolderRepoProc;
import com.elitesland.cbpl.infinity.server.folder.service.InfinityFolderService;
import com.elitesland.cbpl.infinity.server.folder.vo.param.FolderSaveParamVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfinityFolderServiceImpl
implements InfinityFolderService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityFolderServiceImpl.class);
    private final InfinityFolderRepo folderRepo;
    private final InfinityFolderRepoProc folderRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(FolderSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            InfinityFolderDO infinityFolderDO = InfinityFolderConvert.INSTANCE.saveParamToDO(saveParam);
            this.folderRepo.save(infinityFolderDO);
            return infinityFolderDO.getId();
        }
        Optional infinityFolderDO = this.folderRepo.findById(saveParam.getId());
        if (infinityFolderDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinityFolderDO infinityFolder = (InfinityFolderDO)infinityFolderDO.get();
        InfinityFolderConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityFolder);
        this.folderRepo.save(infinityFolder);
        return infinityFolder.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.folderRepoProc.delete(ids);
    }

    public InfinityFolderServiceImpl(InfinityFolderRepo folderRepo, InfinityFolderRepoProc folderRepoProc) {
        this.folderRepo = folderRepo;
        this.folderRepoProc = folderRepoProc;
    }
}

