/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.platform.controller;

import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformSaveParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a5\u53e3\u5e73\u53f0(\u5bf9\u63a5\u7cfb\u7edf)"})
@RestController
@RequestMapping(value={"/infinity/server/platform"})
public class InfinityPlatformController {
    private static final Logger logger = LoggerFactory.getLogger(InfinityPlatformController.class);
    private final InfinityPlatformService platformService;

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public HttpResult<List<PlatformRespVO>> query(@RequestBody PlatformQueryParamVO query) {
        logger.info("[InfinityPlatform] query list param = {}", (Object)query);
        return HttpResult.ok(this.platformService.platformByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<PlatformRespVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[InfinityPlatform] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.platformService.platformById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody @Valid PlatformSaveParamVO saveParam) {
        logger.info("[InfinityPlatform] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.platformService.save(saveParam));
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664[\u9700\u8981\u63d0\u793a\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c]")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[InfinityPlatform] batch physical delete by ids = {}", ids);
        this.platformService.delete(ids);
        return HttpResult.ok();
    }

    public InfinityPlatformController(InfinityPlatformService platformService) {
        this.platformService = platformService;
    }
}

