create table sys_infinity_platform
(
    `id`             bigint       not null comment '唯一标识',
    `platform_name`  varchar(128) not null comment '平台名称',
    `platform_code`  varchar(64)  not null comment '平台编码',
    `server_url`     varchar(255) not null comment '服务url前缀',
    `auth_method`    varchar(32)  not null comment '认证方式',
    `description`    text comment '文档说明(支持markdown)',
    `remark`         varchar(255) default null comment '备注',
    `create_user_id` bigint       default null comment '记录创建者id',
    `creator`        varchar(32)  default null comment '记录创建者',
    `create_time`    datetime(6) default null comment '记录创建时间',
    `modify_user_id` bigint       default null comment '记录最后更新者id',
    `updater`        varchar(32)  default null comment '记录最后更新者',
    `modify_time`    datetime(6) default null comment '记录最后更新时间',
    `delete_flag`    int          default '0' comment '删除标记',
    primary key (id)
) engine=innodb comment = '接口平台(对接系统)';

create table sys_infinity_folder
(
    `id`             bigint      not null comment '唯一标识',
    `platform_code`  varchar(64) not null comment '平台编码',
    `folder_name`    varchar(64) not null comment '目录名称',
    `server_url`     varchar(255) default null comment '服务url前缀',
    `auth_method`    varchar(32) not null comment '认证方式',
    `description`    text comment '文档说明(支持markdown)',
    `remark`         varchar(255) default null comment '备注',
    `create_user_id` bigint       default null comment '记录创建者id',
    `creator`        varchar(32)  default null comment '记录创建者',
    `create_time`    datetime(6) default null comment '记录创建时间',
    `modify_user_id` bigint       default null comment '记录最后更新者id',
    `updater`        varchar(32)  default null comment '记录最后更新者',
    `modify_time`    datetime(6) default null comment '记录最后更新时间',
    `delete_flag`    int          default '0' comment '删除标记',
    primary key (id)
) engine=innodb comment = '接口分组';

create table sys_infinity_api
(
    `id`             bigint        not null comment '唯一标识',
    `platform_code`  varchar(64)   not null comment '平台编码',
    `folder_id`      bigint       default null comment '分组id',
    `server_url`     varchar(255) default null comment '服务url前缀',
    `auth_method`    varchar(32)   not null comment '认证方式',
    `api_code`       varchar(64)   not null comment '接口编码',
    `api_name`       varchar(64)   not null comment '接口名称',
    `api_url`        varchar(1000) not null comment '接口地址',
    `request_method` varchar(16)   not null comment '请求方式',
    `api_status`     int           not null comment '接口状态',
    `header_param`   text comment 'header参数',
    `query_param`    text comment '查询参数',
    `path_param`     text comment '路径参数',
    `media_type`     varchar(64) comment '媒体类型',
    `body_param`     text comment 'body参数',
    `response`       text comment '响应报文结构',
    `description`    text comment '文档说明(支持markdown)',
    `remark`         varchar(255) default null comment '备注',
    `create_user_id` bigint       default null comment '记录创建者id',
    `creator`        varchar(32)  default null comment '记录创建者',
    `create_time`    datetime(6) default null comment '记录创建时间',
    `modify_user_id` bigint       default null comment '记录最后更新者id',
    `updater`        varchar(32)  default null comment '记录最后更新者',
    `modify_time`    datetime(6) default null comment '记录最后更新时间',
    `delete_flag`    int          default '0' comment '删除标记',
    primary key (id)
) engine=innodb comment = '接口定义';

create unique index idx_sys_infinity_api_code on sys_infinity_api (api_code) comment '接口编码全局唯一';

create table sys_infinity_account
(
    `id`             bigint not null comment '唯一标识',
    `belong_tenant`  bigint       default null comment '所属租户',
    `username`       varchar(64)  default null comment '认证账号',
    `password`       varchar(64)  default null comment '认证密码',
    `intercept_uri`  varchar(255) default null comment '拦截地址：逗号分隔',
    `platform_code`  varchar(64)  default null comment '平台编码：wms、boh、美团、旺店通等',
    `tags`           varchar(255) default null comment '自定义标签',
    `remark`         varchar(255) default null comment '备注',
    `create_user_id` bigint       default null comment '记录创建者id',
    `creator`        varchar(32)  default null comment '记录创建者',
    `create_time`    datetime(6) default null comment '记录创建时间',
    `modify_user_id` bigint       default null comment '记录最后更新者id',
    `updater`        varchar(32)  default null comment '记录最后更新者',
    `modify_time`    datetime(6) default null comment '记录最后更新时间',
    `delete_flag`    int          default '0' comment '删除标记',
    primary key (`id`)
) engine=innodb comment='对外提供接口的认证账号';