package com.elitesland.cbpl.infinity.server.account.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.account.entity.QInfinityAccountDO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountPagingParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountPagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Component
@RequiredArgsConstructor
public class InfinityAccountRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityAccountDO infinityAccountDO = QInfinityAccountDO.infinityAccountDO;

    private final QBean<InfinityAccountPagingVO> infinityAccountPagingVO = Projections.bean(
            InfinityAccountPagingVO.class,
            infinityAccountDO.id,
            infinityAccountDO.belongTenant,
            infinityAccountDO.username,
            infinityAccountDO.password,
            infinityAccountDO.interceptUri,
            infinityAccountDO.platformCode,
            infinityAccountDO.tags,
            infinityAccountDO.remark,
            infinityAccountDO.createUserId,
            infinityAccountDO.creator,
            infinityAccountDO.createTime,
            infinityAccountDO.modifyUserId,
            infinityAccountDO.updater,
            infinityAccountDO.modifyTime,
            infinityAccountDO.deleteFlag
    );

    private Predicate pagingWhere(InfinityAccountPagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(infinityAccountDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(infinityAccountDO.id.eq(query.getId()));
        }
        if (ObjectUtil.isNotNull(query.getBelongTenant())) {
            predicates.add(infinityAccountDO.belongTenant.eq(query.getBelongTenant()));
        }
        if (StrUtil.isNotBlank(query.getUsername())) {
            predicates.add(infinityAccountDO.username.eq(query.getUsername()));
        }
        if (StrUtil.isNotBlank(query.getPassword())) {
            predicates.add(infinityAccountDO.password.eq(query.getPassword()));
        }
        if (StrUtil.isNotBlank(query.getInterceptUri())) {
            predicates.add(infinityAccountDO.interceptUri.eq(query.getInterceptUri()));
        }
        if (StrUtil.isNotBlank(query.getPlatformCode())) {
            predicates.add(infinityAccountDO.platformCode.eq(query.getPlatformCode()));
        }
        if (StrUtil.isNotBlank(query.getTags())) {
            predicates.add(infinityAccountDO.tags.eq(query.getTags()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(infinityAccountDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(infinityAccountDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(infinityAccountDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(infinityAccountDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(infinityAccountDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(infinityAccountDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(infinityAccountDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(infinityAccountDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long infinityAccountCountBy(InfinityAccountPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(infinityAccountDO.id)
                .from(infinityAccountDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<InfinityAccountPagingVO> infinityAccountPageBy(InfinityAccountPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(infinityAccountPagingVO)
                .from(infinityAccountDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, infinityAccountDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<InfinityAccountRespVO> infinityAccountVO = Projections.bean(
            InfinityAccountRespVO.class,
            infinityAccountDO.id,
            infinityAccountDO.belongTenant,
            infinityAccountDO.username,
            infinityAccountDO.password,
            infinityAccountDO.interceptUri,
            infinityAccountDO.platformCode,
            infinityAccountDO.tags,
            infinityAccountDO.remark,
            infinityAccountDO.createUserId,
            infinityAccountDO.creator,
            infinityAccountDO.createTime,
            infinityAccountDO.modifyUserId,
            infinityAccountDO.updater,
            infinityAccountDO.modifyTime,
            infinityAccountDO.deleteFlag
    );

    private Predicate where(InfinityAccountQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(infinityAccountDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(infinityAccountDO.id.eq(query.getId()));
        }
        if (ObjectUtil.isNotNull(query.getBelongTenant())) {
            predicates.add(infinityAccountDO.belongTenant.eq(query.getBelongTenant()));
        }
        if (StrUtil.isNotBlank(query.getUsername())) {
            predicates.add(infinityAccountDO.username.eq(query.getUsername()));
        }
        if (StrUtil.isNotBlank(query.getPassword())) {
            predicates.add(infinityAccountDO.password.eq(query.getPassword()));
        }
        if (StrUtil.isNotBlank(query.getInterceptUri())) {
            predicates.add(infinityAccountDO.interceptUri.eq(query.getInterceptUri()));
        }
        if (StrUtil.isNotBlank(query.getPlatformCode())) {
            predicates.add(infinityAccountDO.platformCode.eq(query.getPlatformCode()));
        }
        if (StrUtil.isNotBlank(query.getTags())) {
            predicates.add(infinityAccountDO.tags.eq(query.getTags()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(infinityAccountDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(infinityAccountDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(infinityAccountDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(infinityAccountDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(infinityAccountDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(infinityAccountDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(infinityAccountDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(infinityAccountDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityAccountRespVO> infinityAccountByParam(InfinityAccountQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(infinityAccountVO)
                .from(infinityAccountDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(infinityAccountDO)
                .where(infinityAccountDO.id.in(ids));
        return delete.execute();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(infinityAccountDO)
                .set(infinityAccountDO.deleteFlag, 1)
                .where(infinityAccountDO.id.in(ids));
        return update.execute();
    }
}
