package com.elitesland.cbpl.infinity.server.account.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountPagingParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountSaveParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountDetailVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountPagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
public interface InfinityAccountService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<InfinityAccountPagingVO> infinityAccountPageBy(InfinityAccountPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<InfinityAccountRespVO> infinityAccountByParam(InfinityAccountQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    InfinityAccountDetailVO infinityAccountById(Long id);

    /**
     * 新增
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long create(InfinityAccountSaveParamVO saveParam);

    /**
     * 更新
     *
     * @param saveParam 更新参数
     * @return 业务单据ID
     */
    Long update(InfinityAccountSaveParamVO saveParam);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(InfinityAccountSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, String status);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);

    /**
     * 批量逻辑删除
     *
     * @param ids 业务单据ID
     * @return 更新成功的数量
     */
    long updateDeleteFlag(List<Long> ids);
}
