package com.elitesland.cbpl.infinity.server.folder.repo;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.api.vo.param.ApiQueryParamVO;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.entity.QInfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.vo.resp.FolderRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Component
@RequiredArgsConstructor
public class InfinityFolderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityFolderDO folderDO = QInfinityFolderDO.infinityFolderDO;

    private final QBean<FolderRespVO> folderVO = Projections.bean(
            FolderRespVO.class,
            folderDO.id,
            folderDO.platformCode,
            folderDO.folderName,
            folderDO.serverUrl,
            folderDO.authMethod,
            folderDO.description,
            folderDO.remark,
            folderDO.createUserId,
            folderDO.creator,
            folderDO.createTime,
            folderDO.modifyUserId,
            folderDO.updater,
            folderDO.modifyTime,
            folderDO.deleteFlag
    );

    private Predicate where(ApiQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(folderDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCode())) {
            predicates.add(folderDO.platformCode.eq(query.getPlatformCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityFolderDO> infinityFolderByParam(ApiQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(folderDO)
                .from(folderDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }
    
    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(folderDO)
                .where(folderDO.id.in(ids));
        return delete.execute();
    }
}
