package com.elitesland.cbpl.infinity.server.security.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.server.security.convert.InfinitySecurityConvert;
import com.elitesland.cbpl.infinity.server.security.entity.InfinitySecurityDO;
import com.elitesland.cbpl.infinity.server.security.repo.InfinitySecurityRepo;
import com.elitesland.cbpl.infinity.server.security.repo.InfinitySecurityRepoProc;
import com.elitesland.cbpl.infinity.server.security.service.InfinitySecurityService;
import com.elitesland.cbpl.infinity.server.security.vo.param.InfinitySecuritySaveParamVO;
import com.elitesland.cbpl.infinity.server.security.vo.resp.InfinitySecurityDetailVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/08/26
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinitySecurityServiceImpl implements InfinitySecurityService {

    private final InfinitySecurityRepo infinitySecurityRepo;
    private final InfinitySecurityRepoProc infinitySecurityRepoProc;

    @Override
    public InfinitySecurityDetailVO securityQueryOne(InfinitySecuritySaveParamVO query) {
        var result = infinitySecurityRepoProc.infinitySecurityByParam(query);
        if (CollUtil.size(result) > 1) {
            throw new IllegalArgumentException("[INFINITY][SECURITY] multiple result");
        }
        if (CollUtil.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long save(InfinitySecuritySaveParamVO saveParam) {
        var detail = securityQueryOne(saveParam);
        // 新增
        if (ObjectUtil.isNull(detail)) {
            InfinitySecurityDO infinitySecurityDO = InfinitySecurityConvert.INSTANCE.saveParamToDO(saveParam);
            infinitySecurityRepo.save(infinitySecurityDO);
            return infinitySecurityDO.getId();
        }
        // 修改
        else {
            Optional<InfinitySecurityDO> infinitySecurityDO = infinitySecurityRepo.findById(detail.getId());
            if (infinitySecurityDO.isEmpty()) {
                throw PhoenixException.unexpected("Not Found Data");
            }
            InfinitySecurityDO infinitySecurity = infinitySecurityDO.get();
            InfinitySecurityConvert.INSTANCE.saveParamMergeToDO(saveParam, infinitySecurity);
            infinitySecurityRepo.save(infinitySecurity);
            return infinitySecurity.getId();
        }
    }
}
