/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.security.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.server.security.convert.InfinitySecurityConvert;
import com.elitesland.cbpl.infinity.server.security.entity.InfinitySecurityDO;
import com.elitesland.cbpl.infinity.server.security.repo.InfinitySecurityRepo;
import com.elitesland.cbpl.infinity.server.security.repo.InfinitySecurityRepoProc;
import com.elitesland.cbpl.infinity.server.security.service.InfinitySecurityService;
import com.elitesland.cbpl.infinity.server.security.vo.param.InfinitySecuritySaveParamVO;
import com.elitesland.cbpl.infinity.server.security.vo.resp.InfinitySecurityDetailVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfinitySecurityServiceImpl
implements InfinitySecurityService {
    private static final Logger logger = LoggerFactory.getLogger(InfinitySecurityServiceImpl.class);
    private final InfinitySecurityRepo infinitySecurityRepo;
    private final InfinitySecurityRepoProc infinitySecurityRepoProc;

    @Override
    public InfinitySecurityDetailVO securityQueryOne(InfinitySecuritySaveParamVO query) {
        List<InfinitySecurityDetailVO> result = this.infinitySecurityRepoProc.infinitySecurityByParam(query);
        if (CollUtil.size(result) > 1) {
            throw new IllegalArgumentException("[INFINITY][SECURITY] multiple result");
        }
        if (CollUtil.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(InfinitySecuritySaveParamVO saveParam) {
        InfinitySecurityDetailVO detail = this.securityQueryOne(saveParam);
        if (ObjectUtil.isNull((Object)detail)) {
            InfinitySecurityDO infinitySecurityDO = InfinitySecurityConvert.INSTANCE.saveParamToDO(saveParam);
            this.infinitySecurityRepo.save(infinitySecurityDO);
            return infinitySecurityDO.getId();
        }
        Optional infinitySecurityDO = this.infinitySecurityRepo.findById(detail.getId());
        if (infinitySecurityDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        InfinitySecurityDO infinitySecurity = (InfinitySecurityDO)infinitySecurityDO.get();
        InfinitySecurityConvert.INSTANCE.saveParamMergeToDO(saveParam, infinitySecurity);
        this.infinitySecurityRepo.save(infinitySecurity);
        return infinitySecurity.getId();
    }

    public InfinitySecurityServiceImpl(InfinitySecurityRepo infinitySecurityRepo, InfinitySecurityRepoProc infinitySecurityRepoProc) {
        this.infinitySecurityRepo = infinitySecurityRepo;
        this.infinitySecurityRepoProc = infinitySecurityRepoProc;
    }
}

