/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.domain;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.data.etl.transform.util.TransformUtil;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiDetailVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.logging.infinity.domain.InfinityLogVO;
import com.elitesland.cbpl.logging.infinity.util.InfinityLogUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.lzhpo.tracer.util.TracerUtils;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class InfinityResult<T> {
    private static final Logger logger = LoggerFactory.getLogger(InfinityResult.class);
    @ApiModelProperty(value="\u54cd\u5e94\u503c\u7684\u5b9e\u4f53\u7c7b\u578b")
    private Class<T> responseType;
    private HttpParam param;
    private InfinityLogVO logVO;
    private WebClient.RequestBodySpec uri;

    public List<T> toList() {
        return (List)this.wrapper(response -> response.bodyToFlux(this.responseType).collectList());
    }

    public T toEntity() {
        return (T)this.wrapper(response -> response.bodyToMono(this.responseType));
    }

    private <R> R wrapper(Function<ClientResponse, Mono<R>> fn) {
        LocalDateTime startTime = LocalDateTime.now();
        AtomicReference<Object> httpStatus = new AtomicReference<Object>(null);
        AtomicReference<String> errorMessage = new AtomicReference<String>("");
        Object result = this.uri.exchangeToMono(response -> {
            httpStatus.set(response.statusCode());
            if (response.statusCode() == HttpStatus.OK) {
                return (Mono)fn.apply((ClientResponse)response);
            }
            return response.createException().flatMap(Mono::error);
        }).onErrorResume(e -> {
            httpStatus.set(HttpStatus.INTERNAL_SERVER_ERROR);
            errorMessage.set(ExceptionUtils.formatException((Throwable)e, (int)2000));
            logger.error("[INFINITY][{}] \u63a5\u53e3\u8bf7\u6c42\u5931\u8d25: ", (Object)this.param.getApiCode(), e);
            return Mono.empty();
        }).block();
        LocalDateTime endTime = LocalDateTime.now();
        boolean success = httpStatus.get() == HttpStatus.OK;
        InfinityLogVO infinityLogVO = this.toInfinityParam(result, success, errorMessage.get(), startTime, endTime);
        InfinityLogUtil.record((InfinityLogVO)infinityLogVO);
        LogUtil.info((String)this.param.getBizKey(), (String)("[INFINITY][" + this.param.getApiCode() + "] \u63a5\u53e3\u51fa\u5165\u53c2\u6570:"), (Object)infinityLogVO);
        if (!success) {
            String defaultMessage = "[" + this.param.getApiCode() + "] \u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + ((HttpStatus)httpStatus.get()).value();
            throw new RuntimeException(StrUtil.blankToDefault((CharSequence)errorMessage.get(), (String)defaultMessage));
        }
        return (R)result;
    }

    private InfinityLogVO toInfinityParam(Object responseBody, boolean requestSuccess, String reqFailMsg, LocalDateTime startTime, LocalDateTime endTime) {
        InfinityApiDetailVO apiConfig = this.param.getApiConfig();
        this.logVO.setAddressIp(HttpServletUtil.currentClientIp());
        this.logVO.setRequestTime(DateUtil.format((LocalDateTime)startTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        this.logVO.setResponseTime(DateUtil.format((LocalDateTime)endTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        long spendTime = LocalDateTimeUtil.between((LocalDateTime)startTime, (LocalDateTime)endTime).toMillis();
        this.logVO.setSpendTime(Long.valueOf(spendTime));
        this.logVO.setRequestSuccess(Boolean.valueOf(requestSuccess));
        this.logVO.setRequestFailMessage(reqFailMsg);
        this.logVO.setResponseBody(responseBody);
        this.logVO.setTraceId(TracerUtils.getTraceId());
        this.logVO.setTenantCode(TenantSpiUtil.currentTenantCode());
        this.logVO.setTargetApp(apiConfig.getPlatformCode());
        this.logVO.setBusinessType(apiConfig.getApiCode());
        this.logVO.setBusinessTypeName(apiConfig.getApiName());
        this.logVO.setBusinessKey(this.param.getBizKey());
        String successStatus = apiConfig.getResponseSuccessStatus();
        String responseStatus = "";
        String successSpel = apiConfig.getResponseSuccessSpel();
        if (StrUtil.isNotBlank((CharSequence)successSpel)) {
            LogUtil.info((String)"[INFINITY][ETL] \u63d0\u53d6\u54cd\u5e94\u62a5\u6587\u4e2d\uff0c\u6210\u529f\u72b6\u6001\u6807\u8bc6\u5b57\u6bb5: ");
            responseStatus = TransformUtil.parse((Object)responseBody, (String)successSpel);
        }
        if (StrUtil.isNotBlank((CharSequence)responseStatus) && StrUtil.isNotBlank((CharSequence)successStatus)) {
            boolean status = responseStatus.equals(successStatus);
            this.logVO.setResponseSuccess(Boolean.valueOf(status));
            if (!status) {
                LogUtil.info((String)"[INFINITY][ETL] \u63d0\u53d6\u54cd\u5e94\u62a5\u6587\u4e2d\uff0c\u9519\u8bef\u4fe1\u606f\u5b57\u6bb5: ");
                this.logVO.setResponseFailMessage(TransformUtil.parse((Object)responseBody, (String)apiConfig.getResponseErrorMessageSpel()));
            }
        } else {
            this.logVO.setResponseSuccess(Boolean.valueOf(requestSuccess));
            this.logVO.setResponseFailMessage(reqFailMsg);
        }
        return this.logVO;
    }

    private InfinityResult(Class<T> responseType, HttpParam param, InfinityLogVO logVO, WebClient.RequestBodySpec uri) {
        this.responseType = responseType;
        this.param = param;
        this.logVO = logVO;
        this.uri = uri;
    }

    public static <T> InfinityResult<T> of(Class<T> responseType, HttpParam param, InfinityLogVO logVO, WebClient.RequestBodySpec uri) {
        return new InfinityResult<T>(responseType, param, logVO, uri);
    }
}

