/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.basic;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@UnicomTag(value="BASIC_AUTH")
public class BasicAuthSecurityService
implements SecurityAuthService {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthSecurityService.class);

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info((String)("[BPMN][INFINITY] \u8ba4\u8bc1\u65b9\u5f0f: " + AuthMethod.AUTH_METHOD_BASIC_AUTH.getDesc()));
        BasicAuthAccountVO account = param.getApiConfig().getBasicAuthAccount();
        if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
            LogUtil.info((String)"[BPMN][INFINITY] \u672a\u914d\u7f6e\u8ba4\u8bc1\u8d26\u53f7");
            throw new RuntimeException("account is empty.");
        }
        LogUtil.info((String)("[BPMN][INFINITY] \u8ba4\u8bc1\u8d26\u53f7: " + account.getUsername()));
        uri.headers(headers -> headers.setBasicAuth(account.getUsername(), account.getPassword()));
        return true;
    }
}

