create table sys_infinity_security_storage
(
    `id`                bigint       not null comment '唯一标识',
    `platform_code`     varchar(64)  not null comment '平台编码',
    `folder_id`         bigint       default null comment '分组id',
    `api_code`          varchar(64)  not null comment '接口编码',
    `local_public_key`  varchar(32)  not null comment '客户端公钥',
    `local_private_key` varchar(32)  not null comment '客户端私钥',
    `server_public_key` varchar(32)  not null comment '服务端公钥',
    `server_secret`     varchar(32)  not null comment '服务端密钥',
    `tenant_id`         bigint       default -1 null comment '租户ID',
    `remark`            varchar(255) default null comment '备注',
    `create_user_id`    bigint       default null comment '记录创建者id',
    `creator`           varchar(32)  default null comment '记录创建者',
    `create_time`       datetime(6) default null comment '记录创建时间',
    `modify_user_id`    bigint       default null comment '记录最后更新者id',
    `updater`           varchar(32)  default null comment '记录最后更新者',
    `modify_time`       datetime(6) default null comment '记录最后更新时间',
    `delete_flag`       int          default '0' comment '删除标记',
    primary key (id)
) engine=innodb comment = '接口认证方式扩展表(用于动态数据持久化)';