package com.elitesland.cbpl.infinity.server.security.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 接口认证方式扩展表(用于动态数据持久化)
 *
 * @author eric.hao
 * @since 2024/08/26
 */
@Data
@ApiModel("接口认证方式扩展表(用于动态数据持久化)")
public class InfinitySecurityDetailVO {

	@ApiModelProperty(value = "唯一标识")
	private Long id;

	@ApiModelProperty(value = "平台编码")
	private String platformCode;

	@ApiModelProperty(value = "分组id")
	private Long folderId;

	@ApiModelProperty(value = "接口编码")
	private String apiCode;

	@ApiModelProperty(value = "客户端公钥")
	private String localPublicKey;

	@ApiModelProperty(value = "客户端私钥")
	private String localPrivateKey;

	@ApiModelProperty(value = "服务端公钥")
	private String serverPublicKey;

	@ApiModelProperty(value = "服务端密钥")
	private String serverSecret;

	@ApiModelProperty(value = "租户ID")
	private Long tenantId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者id")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者id")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
