package com.elitesland.cbpl.infinity.web.security.service.basic;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * `@UnicomTag` 参考 {@link AuthMethod}
 *
 * @author eric.hao
 * @since 2024/06/07
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("BASIC_AUTH")
public class BasicAuthSecurityService implements SecurityAuthService {

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info("[BPMN][INFINITY] 认证方式: " + AuthMethod.AUTH_METHOD_BASIC_AUTH.getDesc());
        BasicAuthAccountVO account = param.getApiConfig().getBasicAuthAccount();
        if (ObjectUtil.isNull(account) || account.isEmpty()) {
            LogUtil.info("[BPMN][INFINITY] 未配置认证账号");
            throw new RuntimeException("account is empty.");
        }
        LogUtil.info("[BPMN][INFINITY] 认证账号: " + account.getUsername());
        uri.headers(headers -> headers.setBasicAuth(account.getUsername(), account.getPassword()));
        return true;
    }
}
