package com.elitesland.cbpl.infinity.web.security.service.weaver.domain;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/08/22
 */
@Data
@ApiModel("许可证注册")
public class WeaverRegisterVO extends WeaverRespVO {

    /**
     * 注意此处secrit单词拼写错误（原词为：secret），请使用 secrit获取结果
     */
    @ApiModelProperty("秘钥信息")
    private String secrit;

    @ApiModelProperty("秘钥信息")
    private String secret;

    /**
     * 按E9接口文档中描述，如果secrit有值 则使用secrit的值；反之，使用secret；
     */
    @JsonProperty
    public String getSecret() {
        return StrUtil.blankToDefault(secrit, secret);
    }

    @ApiModelProperty("系统公钥信息")
    private String spk;
}
