package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service.WeaverE9Service;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util.WeaverE9Key;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2024/08/26
 */
@Slf4j
@Api(tags = "泛微E9接口")
@RestController
@RequestMapping("/weaver/e9")
@RequiredArgsConstructor
public class WeaverE9Controller {

    private final WeaverE9Service weaverE9Service;
    private final InfinityRestClient restClient;

    @ApiOperation("01.手动注册许可证")
    @PostMapping("/register")
    public void register(@RequestBody WeaverAccountVO accountVO) {
        weaverE9Service.register(accountVO);
    }

    @ApiOperation("02.重新注册许可证")
    @PostMapping("/register/refresh")
    public void refreshRegister(@RequestBody WeaverAccountVO accountVO) {
        weaverE9Service.refreshRegister(accountVO);
    }

    @ApiOperation("03.仅删除系统缓存")
    @DeleteMapping("/cache/clear")
    public void removeCache() {
        WeaverE9Key.removeCache();
    }

    @ApiOperation(value = "04.测试")
    @GetMapping("/invoke/{apiCode}")
    public JSONObject invoke(@PathVariable("apiCode") String apiCode) {
        String param = "[{\"fieldName\":\"clrq\",\"fieldValue\":\"2020-08-31\"},{\"fieldName\":\"zczbwb\",\"fieldValue\":\"1000\"},{\"fieldName\":\"sjzb\",\"fieldValue\":\"8000\"},{\"fieldName\":\"qymc\",\"fieldValue\":\"河南xx有限责任公司\"},{\"fieldName\":\"zczz\",\"fieldValue\":\"10000\"},{\"fieldName\":\"gszch\",\"fieldValue\":\"20202020200202\"},{\"fieldName\":\"jyfw\",\"fieldValue\":\"经营范围经营范围经营范围经营范围经营范围经营范围经营\"},{\"fieldName\":\"qyjc\",\"fieldValue\":\"河南xx\"},{\"fieldName\":\"sqr\",\"fieldValue\":\"4460\"},{\"fieldName\":\"dz\",\"fieldValue\":\"河南xx国贸大厦\"},{\"fieldName\":\"zzjgdm\",\"fieldValue\":\"606060606060606060\"},{\"fieldName\":\"yx\",\"fieldValue\":\"12345678@qq.com\"},{\"fieldName\":\"gysfl\",\"fieldValue\":\"固定资产/null\"},{\"fieldName\":\"gysxz\",\"fieldValue\":\"民营企业\"},{\"fieldName\":\"ywrs\",\"fieldValue\":500},{\"fieldName\":\"sqrq\",\"fieldValue\":\"2024-09-05\"},{\"fieldName\":\"zczb\",\"fieldValue\":\"10000\"},{\"fieldName\":\"tyshxydm\",\"fieldValue\":\"101010101001017\"},{\"fieldName\":\"nsrsbh\",\"fieldValue\":\"303030300300303\"},{\"fieldName\":\"sfl\",\"fieldValue\":\"小规模纳税人\"},{\"fieldName\":\"zyrs\",\"fieldValue\":1000},{\"fieldName\":\"frdbr\",\"fieldValue\":\"张三\"},{\"fieldName\":\"jsrs\",\"fieldValue\":200},{\"fieldName\":\"qygm\",\"fieldValue\":\"大型\"},{\"fieldName\":\"sndxse\",\"fieldValue\":\"10000\"},{\"fieldName\":\"srmbh\",\"fieldValue\":\"SU00000149\"},{\"fieldName\":\"gswz\",\"fieldValue\":\"https://hnzs.com\"}]";
        var result = restClient.exchange(apiCode, (builder) -> {
            MultiValueMap<String, String> queryParam = new LinkedMultiValueMap<>();
            queryParam.add("requestName", "供应商[河南xx有限责任公司]注册申请");
            queryParam.add("mainData", param);
            queryParam.add("workflowId", "174");
            builder.queryParam(queryParam);
            return builder.build();
        });
        return JSONUtil.parseObj(result.toEntity());
    }
}
