/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.security.interceptor;

import com.elitesland.cbpl.infinity.client.security.session.InfinitySession;
import com.elitesland.cbpl.infinity.client.security.spi.InfinityAuthListener;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.crypto.BasicAuthUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    private List<InfinityAccountRespVO> accounts;
    private InfinityAuthListener infinityAuthListener;

    public AuthInterceptor(List<InfinityAccountRespVO> accounts) {
        this.accounts = accounts;
    }

    public AuthInterceptor(List<InfinityAccountRespVO> accounts, InfinityAuthListener infinityAuthListener) {
        this.accounts = accounts;
        this.infinityAuthListener = infinityAuthListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler) throws IOException {
        Optional<InfinityAccountRespVO> matchAccount;
        block9: {
            String token;
            block8: {
                response.addHeader("Content-Type", "application/json");
                response.setCharacterEncoding("UTF-8");
                if (this.infinityAuthListener != null) {
                    this.infinityAuthListener.preHandle(request);
                }
                token = request.getHeader("Authorization");
                LogUtil.info((String)"", (String)"[INFINITY] \u8bfb\u53d6\u8bf7\u6c42token\uff1a", (Object)token);
                if (!StringUtils.isBlank((CharSequence)token)) break block8;
                HttpResult result = HttpResult.unauthorized((String)"\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u8ba4\u8bc1\u5931\u8d25");
                response.getWriter().write(BeanUtils.toJsonStr((Object)result));
                LogUtil.info((String)"[INFINITY] \u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u8ba4\u8bc1\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            matchAccount = this.accounts.stream().filter(account -> BasicAuthUtil.checkSignature((String)token, (String)account.getUsername(), (String)account.getPassword())).findFirst();
            if (!matchAccount.isEmpty()) break block9;
            HttpResult result = HttpResult.result((int)203, (String)"\u7528\u6237\u540d\u5bc6\u7801\uff0c\u8ba4\u8bc1\u5931\u8d25");
            response.getWriter().write(BeanUtils.toJsonStr((Object)result));
            LogUtil.info((String)"[INFINITY] \u7528\u6237\u540d\u5bc6\u7801\uff0c\u8ba4\u8bc1\u5931\u8d25");
            boolean bl = false;
            return bl;
        }
        try {
            LogUtil.info((String)"[INFINITY] \u8ba4\u8bc1\u6210\u529f\uff01");
            InfinitySession.setCurrentAccount(matchAccount.get());
            if (this.infinityAuthListener != null) {
                this.infinityAuthListener.preCompleteHandle(matchAccount.get());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            HttpResult result = HttpResult.internalServerError((String)"\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            response.getWriter().write(BeanUtils.toJsonStr((Object)result));
            LogUtil.error((String)"[INFINITY] \u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    public void postHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, ModelAndView modelAndView) {
        if (this.infinityAuthListener != null) {
            this.infinityAuthListener.postHandle();
        }
        InfinitySession.clearCurrentAccount();
    }

    public void afterCompletion(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, Exception e) {
    }

    public List<InfinityAccountRespVO> getAccounts() {
        return this.accounts;
    }

    public InfinityAuthListener getInfinityAuthListener() {
        return this.infinityAuthListener;
    }

    public void setAccounts(List<InfinityAccountRespVO> accounts) {
        this.accounts = accounts;
    }

    public void setInfinityAuthListener(InfinityAuthListener infinityAuthListener) {
        this.infinityAuthListener = infinityAuthListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInterceptor)) {
            return false;
        }
        AuthInterceptor other = (AuthInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<InfinityAccountRespVO> this$accounts = this.getAccounts();
        List<InfinityAccountRespVO> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        InfinityAuthListener this$infinityAuthListener = this.getInfinityAuthListener();
        InfinityAuthListener other$infinityAuthListener = other.getInfinityAuthListener();
        return !(this$infinityAuthListener == null ? other$infinityAuthListener != null : !this$infinityAuthListener.equals(other$infinityAuthListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<InfinityAccountRespVO> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        InfinityAuthListener $infinityAuthListener = this.getInfinityAuthListener();
        result = result * 59 + ($infinityAuthListener == null ? 43 : $infinityAuthListener.hashCode());
        return result;
    }

    public String toString() {
        return "AuthInterceptor(accounts=" + this.getAccounts() + ", infinityAuthListener=" + this.getInfinityAuthListener() + ")";
    }

    public AuthInterceptor() {
    }
}

