/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.security.service.SecurityAuthService;
import com.elitesland.cbpl.infinity.web.security.service.weaver.domain.WeaverAccountVO;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.service.WeaverE9Service;
import com.elitesland.cbpl.infinity.web.security.service.weaver.e9.util.WeaverE9Util;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@UnicomTag(value="WEAVER_E9")
public class WeaverE9AuthService
implements SecurityAuthService {
    private static final Logger logger = LoggerFactory.getLogger(WeaverE9AuthService.class);
    private final WeaverE9Service weaverE9Service;

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        LogUtil.info((String)("[BPMN][WEAVER-E9] \u8ba4\u8bc1\u65b9\u5f0f\uff1a" + AuthMethod.AUTH_METHOD_WEAVER_E9.getDesc()));
        String accountStr = param.getApiConfig().getAuthAccount();
        WeaverAccountVO accountVO = (WeaverAccountVO)BeanUtils.toBean((String)accountStr, WeaverAccountVO.class);
        if (accountVO.isEmpty()) {
            LogUtil.info((String)"[BPMN][WEAVER-E9] \u672a\u7ef4\u62a4\u8ba4\u8bc1\u8d26\u53f7.");
            throw new RuntimeException("Weaver Account Empty.");
        }
        accountVO.setPlatformCode(param.getPlatformCode());
        accountVO.setFolderId(param.getApiConfig().getFolderId());
        accountVO.setApiCode(param.getApiCode());
        String accessToken = this.weaverE9Service.getAccessToken(accountVO);
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            LogUtil.info((String)"[BPMN][WEAVER-E9] token\u4e3a\u7a7a.");
            return false;
        }
        uri.header("token", new String[]{accessToken});
        uri.header("appid", new String[]{accountVO.getAppid()});
        uri.header("skipsession", new String[]{accountVO.getSkip()});
        uri.headers(headers -> {
            List userIds;
            if (headers.containsKey((Object)"userId") && CollUtil.isNotEmpty((Collection)(userIds = headers.remove((Object)"userId")))) {
                headers.set("userId", WeaverE9Util.encrypt(accountVO.getPrefix(), (String)userIds.get(0)));
            }
        });
        return true;
    }

    public WeaverE9AuthService(WeaverE9Service weaverE9Service) {
        this.weaverE9Service = weaverE9Service;
    }
}

